/*
 * Decompiled with CFR 0.152.
 */
package tetris.bot;

import nintaco.api.API;
import nintaco.api.ApiSource;
import tetris.ai.AI;
import tetris.ai.PlayfieldUtil;
import tetris.ai.State;
import tetris.ai.Tetriminos;

public class TetrisBot {
    private static final int EMPTY_SQUARE = 239;
    private final API api = ApiSource.getAPI();
    private final AI ai = new AI();
    private final PlayfieldUtil playfieldUtil = new PlayfieldUtil();
    private final int[] tetriminos = new int[2];
    private final int[][] playfield = this.playfieldUtil.createPlayfield();
    private final int[] TetriminosTypes = new int[19];
    private final boolean playFast;
    private int playingDelay;
    private int targetTetriminoY;
    private int startCounter;
    private int movesIndex;
    private boolean moving;
    private State[] states;

    public TetrisBot(boolean playFast) {
        this.playFast = playFast;
    }

    public void launch() throws Throwable {
        this.api.addActivateListener(this::apiEnabled);
        this.api.addAccessPointListener(this::updateScore, 4, 39989);
        this.api.addAccessPointListener(this::speedUpDrop, 4, 35191);
        this.api.addAccessPointListener(this::tetriminoYUpdated, 2, 97);
        this.api.addAccessPointListener(this::tetriminoYUpdated, 2, 65);
        this.api.addFrameListener(this::renderFinished);
        this.api.addStatusListener(this::statusChanged);
        this.api.run();
    }

    private void apiEnabled() {
        this.readTetriminoTypes();
    }

    private int tetriminoYUpdated(int type, int address, int tetriminoY) {
        if (tetriminoY == 0) {
            this.targetTetriminoY = 0;
        }
        if (this.moving) {
            return this.targetTetriminoY;
        }
        return tetriminoY;
    }

    private void readTetriminoTypes() {
        for (int i = 0; i < 19; ++i) {
            this.TetriminosTypes[i] = this.api.readCPU(39227 + i);
        }
    }

    private void resetPlayState(int gameState) {
        if (gameState != 4) {
            this.api.writeCPU(104, 0);
        }
    }

    private int updateScore(int type, int address, int value) {
        if (this.api.readCPU(168) > 30) {
            this.api.writeCPU(168, 30);
        }
        return -1;
    }

    private int speedUpDrop(int type, int address, int value) {
        this.api.setX(30);
        return -1;
    }

    private void setTetriminoYAddress(int address, int y) {
        this.targetTetriminoY = y;
        this.api.writeCPU(address, y);
    }

    private void setTetriminoY(int y) {
        this.setTetriminoYAddress(97, y);
        this.setTetriminoYAddress(65, y);
    }

    private void makeMove(int tetriminoType, State state, boolean finalMove) {
        if (finalMove) {
            this.api.writeCPU(110, 3);
        }
        this.api.writeCPU(96, state.x);
        this.setTetriminoY(state.y);
        this.api.writeCPU(98, Tetriminos.ORIENTATIONS[tetriminoType][state.rotation].orientationID);
    }

    private int readTetrimino() {
        return this.TetriminosTypes[this.api.readCPU(98)];
    }

    private int readNextTetrimino() {
        return this.TetriminosTypes[this.api.readCPU(191)];
    }

    private void readPlayfield() {
        this.tetriminos[0] = this.readTetrimino();
        this.tetriminos[1] = this.readNextTetrimino();
        for (int i = 0; i < 20; ++i) {
            this.playfield[i][10] = 0;
            for (int j = 0; j < 10; ++j) {
                if (this.api.readCPU(1024 + 10 * i + j) == 239) {
                    this.playfield[i][j] = -1;
                    continue;
                }
                this.playfield[i][j] = 6;
                int[] nArray = this.playfield[i];
                nArray[10] = nArray[10] + 1;
            }
        }
    }

    private boolean spawned() {
        int currentTetrimino = this.api.readCPU(98);
        int playState = this.api.readCPU(104);
        int tetriminoX = this.api.readCPU(96);
        int tetriminoY = this.api.readCPU(97);
        return playState == 1 && tetriminoX == 5 && tetriminoY == 0 && currentTetrimino < this.TetriminosTypes.length;
    }

    private boolean isPlaying(int gameState) {
        return gameState == 4 && this.api.readCPU(104) < 9;
    }

    private void pressStart() {
        this.startCounter = this.startCounter > 0 ? --this.startCounter : 10;
        if (this.startCounter >= 5) {
            this.api.writeGamepad(0, 3, true);
        }
    }

    private void skipCopyrightScreen(int gameState) {
        if (gameState == 0) {
            if (this.api.readCPU(195) > 1) {
                this.api.writeCPU(195, 0);
            } else if (this.api.readCPU(168) > 2) {
                this.api.writeCPU(168, 1);
            }
        }
    }

    private void skipTitleAndDemoScreens(int gameState) {
        if (gameState == 1 || gameState == 5) {
            this.pressStart();
        } else {
            this.startCounter = 0;
        }
    }

    private void renderFinished() {
        int gameState = this.api.readCPU(192);
        this.skipCopyrightScreen(gameState);
        this.skipTitleAndDemoScreens(gameState);
        this.resetPlayState(gameState);
        if (this.isPlaying(gameState)) {
            if (this.playingDelay > 0) {
                --this.playingDelay;
            } else if (this.playFast) {
                if (this.api.readCPU(104) == 4) {
                    this.api.writeCPU(104, 5);
                }
                if (this.spawned()) {
                    this.readPlayfield();
                    State state = this.ai.search(this.playfield, this.tetriminos);
                    if (state != null) {
                        this.moving = true;
                        this.makeMove(this.tetriminos[0], state, true);
                        this.moving = false;
                    }
                }
            } else if (this.moving && this.movesIndex < this.states.length) {
                this.makeMove(this.tetriminos[0], this.states[this.movesIndex], this.movesIndex == this.states.length - 1);
                ++this.movesIndex;
            } else {
                this.moving = false;
                if (this.spawned()) {
                    this.readPlayfield();
                    State state = this.ai.search(this.playfield, this.tetriminos);
                    if (state != null) {
                        this.states = this.ai.buildStatesList(state);
                        this.movesIndex = 0;
                        this.moving = true;
                    }
                }
            }
        } else {
            this.states = null;
            this.moving = false;
            this.playingDelay = 16;
        }
    }

    private void statusChanged(String message) {
        System.out.println(message);
    }

    public static void main(String ... args) throws Throwable {
        ApiSource.initRemoteAPI((String)"localhost", (int)9999);
        new TetrisBot(args.length > 0 && "fast".equals(args[0].toLowerCase())).launch();
    }
}

