/*
 * Decompiled with CFR 0.152.
 */
package tetris.ai;

import java.util.ArrayList;
import tetris.ai.Orientation;

public final class Tetriminos {
    public static final int NONE = -1;
    public static final int T = 0;
    public static final int J = 1;
    public static final int Z = 2;
    public static final int O = 3;
    public static final int S = 4;
    public static final int L = 5;
    public static final int I = 6;
    public static final int[][][][] PATTERNS = new int[][][][]{new int[][][]{new int[][]{{-1, 0}, {0, 0}, {1, 0}, {0, 1}}, new int[][]{{0, -1}, {-1, 0}, {0, 0}, {0, 1}}, new int[][]{{-1, 0}, {0, 0}, {1, 0}, {0, -1}}, new int[][]{{0, -1}, {0, 0}, {1, 0}, {0, 1}}}, new int[][][]{new int[][]{{-1, 0}, {0, 0}, {1, 0}, {1, 1}}, new int[][]{{0, -1}, {0, 0}, {-1, 1}, {0, 1}}, new int[][]{{-1, -1}, {-1, 0}, {0, 0}, {1, 0}}, new int[][]{{0, -1}, {1, -1}, {0, 0}, {0, 1}}}, new int[][][]{new int[][]{{-1, 0}, {0, 0}, {0, 1}, {1, 1}}, new int[][]{{1, -1}, {0, 0}, {1, 0}, {0, 1}}}, new int[][][]{new int[][]{{-1, 0}, {0, 0}, {-1, 1}, {0, 1}}}, new int[][][]{new int[][]{{0, 0}, {1, 0}, {-1, 1}, {0, 1}}, new int[][]{{0, -1}, {0, 0}, {1, 0}, {1, 1}}}, new int[][][]{new int[][]{{-1, 0}, {0, 0}, {1, 0}, {-1, 1}}, new int[][]{{-1, -1}, {0, -1}, {0, 0}, {0, 1}}, new int[][]{{1, -1}, {-1, 0}, {0, 0}, {1, 0}}, new int[][]{{0, -1}, {0, 0}, {0, 1}, {1, 1}}}, new int[][][]{new int[][]{{-2, 0}, {-1, 0}, {0, 0}, {1, 0}}, new int[][]{{0, -2}, {0, -1}, {0, 0}, {0, 1}}}};
    public static final int[] ORIENTATION_IDS = new int[]{2, 3, 0, 1, 7, 4, 5, 6, 8, 9, 10, 11, 12, 14, 15, 16, 13, 18, 17};
    public static final Orientation[][] ORIENTATIONS = new Orientation[PATTERNS.length][];

    private Tetriminos() {
    }

    static {
        int idIndex = 0;
        for (int i = 0; i < PATTERNS.length; ++i) {
            ArrayList<Orientation> tetriminos = new ArrayList<Orientation>();
            for (int j = 0; j < PATTERNS[i].length; ++j) {
                Orientation tetrimino = new Orientation();
                tetriminos.add(tetrimino);
                int minX = Integer.MAX_VALUE;
                int maxX = Integer.MIN_VALUE;
                int maxY = Integer.MIN_VALUE;
                for (int k = 0; k < 4; ++k) {
                    int[] p = PATTERNS[i][j][k];
                    tetrimino.squares[k].x = p[0];
                    tetrimino.squares[k].y = p[1];
                    minX = Math.min(minX, p[0]);
                    maxX = Math.max(maxX, p[0]);
                    maxY = Math.max(maxY, p[1]);
                }
                tetrimino.minX = -minX;
                tetrimino.maxX = 10 - maxX - 1;
                tetrimino.maxY = 20 - maxY - 1;
                tetrimino.orientationID = ORIENTATION_IDS[idIndex++];
            }
            Tetriminos.ORIENTATIONS[i] = new Orientation[tetriminos.size()];
            tetriminos.toArray(ORIENTATIONS[i]);
        }
    }
}

