/*
 * Decompiled with CFR 0.152.
 */
package tetris.ai;

import tetris.ai.IChildFilter;
import tetris.ai.ISearchListener;
import tetris.ai.Orientation;
import tetris.ai.Point;
import tetris.ai.Queue;
import tetris.ai.State;
import tetris.ai.Tetriminos;

public class Searcher {
    private static int globalMark = 1;
    private State[][][] states;
    private Queue queue = new Queue();
    private ISearchListener searchListener;
    private IChildFilter positionValidator;

    public Searcher(ISearchListener searchListener, IChildFilter positionValidator) {
        this.searchListener = searchListener;
        this.positionValidator = positionValidator;
        this.createStates();
    }

    private void createStates() {
        this.states = new State[20][10][4];
        for (int y = 0; y < 20; ++y) {
            for (int x = 0; x < 10; ++x) {
                for (int rotation = 0; rotation < 4; ++rotation) {
                    this.states[y][x][rotation] = new State(x, y, rotation);
                }
            }
        }
    }

    private void lockTetrimino(int[][] playfield, int tetriminoType, int id, State state) {
        int y;
        Point square;
        int i;
        Point[] squares = Tetriminos.ORIENTATIONS[tetriminoType][state.rotation].squares;
        for (i = 0; i < 4; ++i) {
            square = squares[i];
            y = state.y + square.y;
            if (y < 0) continue;
            playfield[y][state.x + square.x] = tetriminoType;
            int[] nArray = playfield[y];
            nArray[10] = nArray[10] + 1;
        }
        this.searchListener.handleResult(playfield, tetriminoType, id, state);
        for (i = 0; i < 4; ++i) {
            square = squares[i];
            y = state.y + square.y;
            if (y < 0) continue;
            playfield[y][state.x + square.x] = -1;
            int[] nArray = playfield[y];
            nArray[10] = nArray[10] - 1;
        }
    }

    private boolean addChild(int[][] playfield, int tetriminoType, int mark, State state, int x, int y, int rotation) {
        Orientation orientation = Tetriminos.ORIENTATIONS[tetriminoType][rotation];
        if (x < orientation.minX || x > orientation.maxX || y > orientation.maxY) {
            return false;
        }
        State childNode = this.states[y][x][rotation];
        if (childNode.visited == mark) {
            return true;
        }
        Point[] squares = orientation.squares;
        for (int i = 0; i < 4; ++i) {
            Point square = squares[i];
            int playfieldY = y + square.y;
            if (playfieldY < 0 || playfield[playfieldY][x + square.x] == -1) continue;
            return false;
        }
        if (this.positionValidator != null && !this.positionValidator.validate(playfield, tetriminoType, x, y, rotation)) {
            return true;
        }
        childNode.visited = mark;
        childNode.predecessor = state;
        this.queue.enqueue(childNode);
        return true;
    }

    public boolean search(int[][] playfield, int tetriminoType, int id) {
        int mark;
        int maxRotation = Tetriminos.ORIENTATIONS[tetriminoType].length - 1;
        if (!this.addChild(playfield, tetriminoType, mark = globalMark++, null, 5, 0, 0)) {
            return false;
        }
        while (this.queue.isNotEmpty()) {
            State state = this.queue.dequeue();
            if (maxRotation != 0) {
                this.addChild(playfield, tetriminoType, mark, state, state.x, state.y, state.rotation == 0 ? maxRotation : state.rotation - 1);
                if (maxRotation != 1) {
                    this.addChild(playfield, tetriminoType, mark, state, state.x, state.y, state.rotation == maxRotation ? 0 : state.rotation + 1);
                }
            }
            this.addChild(playfield, tetriminoType, mark, state, state.x - 1, state.y, state.rotation);
            this.addChild(playfield, tetriminoType, mark, state, state.x + 1, state.y, state.rotation);
            if (this.addChild(playfield, tetriminoType, mark, state, state.x, state.y + 1, state.rotation)) continue;
            this.lockTetrimino(playfield, tetriminoType, id, state);
        }
        return true;
    }
}

