/*
 * Decompiled with CFR 0.152.
 */
package tetris.ai;

import tetris.ai.PlayfieldEvaluation;
import tetris.ai.Point;
import tetris.ai.State;
import tetris.ai.Tetriminos;

public class PlayfieldUtil {
    private final int[][] spareRows = new int[16][11];
    private final int[] columnDepths = new int[10];
    private int spareIndex;

    public PlayfieldUtil() {
        for (int y = 0; y < this.spareRows.length; ++y) {
            for (int x = 0; x < 10; ++x) {
                this.spareRows[y][x] = -1;
            }
        }
    }

    public int[][] createPlayfield() {
        int[][] playfield = new int[20][11];
        for (int y = 0; y < 20; ++y) {
            for (int x = 0; x < 10; ++x) {
                playfield[y][x] = -1;
            }
        }
        return playfield;
    }

    public void lockTetrimino(int[][] playfield, int tetriminoType, State state) {
        int y;
        Point[] squares = Tetriminos.ORIENTATIONS[tetriminoType][state.rotation].squares;
        for (int i = 0; i < 4; ++i) {
            Point square = squares[i];
            y = state.y + square.y;
            if (y < 0) continue;
            playfield[y][state.x + square.x] = tetriminoType;
            int[] nArray = playfield[y];
            nArray[10] = nArray[10] + 1;
        }
        int startRow = state.y - 2;
        int endRow = state.y + 1;
        if (startRow < 1) {
            startRow = 1;
        }
        if (endRow >= 20) {
            endRow = 19;
        }
        for (y = startRow; y <= endRow; ++y) {
            if (playfield[y][10] != 10) continue;
            int[] clearedRow = playfield[y];
            for (int i = y; i > 0; --i) {
                playfield[i] = playfield[i - 1];
            }
            for (int x = 0; x < 10; ++x) {
                clearedRow[x] = -1;
            }
            clearedRow[10] = 0;
            playfield[0] = clearedRow;
        }
    }

    public void evaluatePlayfield(int[][] playfield, PlayfieldEvaluation e) {
        int y;
        int x;
        block0: for (x = 0; x < 10; ++x) {
            this.columnDepths[x] = 19;
            for (int y2 = 0; y2 < 20; ++y2) {
                if (playfield[y2][x] == -1) continue;
                this.columnDepths[x] = y2;
                continue block0;
            }
        }
        e.wells = 0;
        for (x = 0; x < 10; ++x) {
            int minY = 0;
            minY = x == 0 ? this.columnDepths[1] : (x == 9 ? this.columnDepths[8] : Math.max(this.columnDepths[x - 1], this.columnDepths[x + 1]));
            for (y = this.columnDepths[x]; y >= minY; --y) {
                if (x != 0 && playfield[y][x - 1] == -1 || x != 9 && playfield[y][x + 1] == -1) continue;
                ++e.wells;
            }
        }
        e.holes = 0;
        e.columnTransitions = 0;
        for (x = 0; x < 10; ++x) {
            boolean solid = true;
            for (y = this.columnDepths[x] + 1; y < 20; ++y) {
                if (playfield[y][x] == -1) {
                    if (playfield[y - 1][x] != -1) {
                        ++e.holes;
                    }
                    if (!solid) continue;
                    solid = false;
                    ++e.columnTransitions;
                    continue;
                }
                if (solid) continue;
                solid = true;
                ++e.columnTransitions;
            }
        }
        e.rowTransitions = 0;
        for (int y3 = 0; y3 < 20; ++y3) {
            boolean solidFound = false;
            boolean solid = true;
            int transitions = 0;
            for (int x2 = 0; x2 <= 10; ++x2) {
                if (x2 == 10) {
                    if (solid) continue;
                    ++transitions;
                    continue;
                }
                if (playfield[y3][x2] == -1) {
                    if (!solid) continue;
                    solid = false;
                    ++transitions;
                    continue;
                }
                solidFound = true;
                if (solid) continue;
                solid = true;
                ++transitions;
            }
            if (!solidFound) continue;
            e.rowTransitions += transitions;
        }
    }

    public int clearRows(int[][] playfield, int tetriminoY) {
        int rows = 0;
        int startRow = tetriminoY - 2;
        int endRow = tetriminoY + 1;
        if (startRow < 1) {
            startRow = 1;
        }
        if (endRow >= 20) {
            endRow = 19;
        }
        for (int y = startRow; y <= endRow; ++y) {
            if (playfield[y][10] != 10) continue;
            ++rows;
            this.clearRow(playfield, y);
        }
        return rows;
    }

    private void clearRow(int[][] playfield, int y) {
        int[] clearedRow = playfield[y];
        clearedRow[10] = y;
        for (int i = y; i > 0; --i) {
            playfield[i] = playfield[i - 1];
        }
        playfield[0] = this.spareRows[this.spareIndex];
        playfield[0][10] = 0;
        this.spareRows[this.spareIndex++] = clearedRow;
    }

    private void restoreRow(int[][] playfield) {
        int[] restoredRow = this.spareRows[--this.spareIndex];
        int y = restoredRow[10];
        this.spareRows[this.spareIndex] = playfield[0];
        for (int i = 0; i < y; ++i) {
            playfield[i] = playfield[i + 1];
        }
        restoredRow[10] = 10;
        playfield[y] = restoredRow;
    }

    public void restoreRows(int[][] playfield, int rows) {
        for (int i = 0; i < rows; ++i) {
            this.restoreRow(playfield);
        }
    }
}

