/*
 * Decompiled with CFR 0.152.
 */
package tetris.ai;

import tetris.ai.IChildFilter;
import tetris.ai.ISearchListener;
import tetris.ai.Orientation;
import tetris.ai.PlayfieldEvaluation;
import tetris.ai.PlayfieldUtil;
import tetris.ai.Searcher;
import tetris.ai.State;
import tetris.ai.Tetriminos;

public class AI {
    public static final int PLAYFIELD_WIDTH = 10;
    public static final int PLAYFIELD_HEIGHT = 20;
    public static final int TETRIMINOS_SEARCHED = 2;
    private static final double[] WEIGHTS = new double[]{1.0, 12.885008263218383, 15.842707182438396, 26.89449650779595, 27.616914062397015, 30.18511071927904};
    private Searcher[] searchers;
    private int[] tetriminoIndices;
    private PlayfieldUtil playfieldUtil = new PlayfieldUtil();
    private PlayfieldEvaluation e = new PlayfieldEvaluation();
    private int totalRows;
    private int totalDropHeight;
    private double bestFitness;
    private State bestResult;
    private State result0;
    private ISearchListener searchListener = new ISearchListener(){

        @Override
        public void handleResult(int[][] playfield, int tetriminoType, int id, State state) {
            if (id == 0) {
                AI.this.result0 = state;
            }
            Orientation orientation = Tetriminos.ORIENTATIONS[tetriminoType][state.rotation];
            int rows = AI.this.playfieldUtil.clearRows(playfield, state.y);
            int originalTotalRows = AI.this.totalRows;
            int originalTotalDropHeight = AI.this.totalDropHeight;
            AI.this.totalRows = AI.this.totalRows + rows;
            AI.this.totalDropHeight = AI.this.totalDropHeight + (orientation.maxY - state.y);
            int nextID = id + 1;
            if (nextID == AI.this.tetriminoIndices.length) {
                AI.this.playfieldUtil.evaluatePlayfield(playfield, AI.this.e);
                double fitness = AI.this.computeFitness();
                if (fitness < AI.this.bestFitness) {
                    AI.this.bestFitness = fitness;
                    AI.this.bestResult = AI.this.result0;
                }
            } else {
                AI.this.searchers[nextID].search(playfield, AI.this.tetriminoIndices[nextID], nextID);
            }
            AI.this.totalDropHeight = originalTotalDropHeight;
            AI.this.totalRows = originalTotalRows;
            AI.this.playfieldUtil.restoreRows(playfield, rows);
        }
    };

    public AI() {
        this(null);
    }

    public AI(IChildFilter positionValidator) {
        this.searchers = new Searcher[2];
        for (int i = 0; i < 2; ++i) {
            this.searchers[i] = new Searcher(this.searchListener, positionValidator);
        }
    }

    private double computeFitness() {
        return WEIGHTS[0] * (double)this.totalRows + WEIGHTS[1] * (double)this.totalDropHeight + WEIGHTS[2] * (double)this.e.wells + WEIGHTS[3] * (double)this.e.holes + WEIGHTS[4] * (double)this.e.columnTransitions + WEIGHTS[5] * (double)this.e.rowTransitions;
    }

    public State search(int[][] playfield, int[] tetriminoIndices) {
        this.tetriminoIndices = tetriminoIndices;
        this.bestResult = null;
        this.bestFitness = Double.MAX_VALUE;
        this.searchers[0].search(playfield, tetriminoIndices[0], 0);
        return this.bestResult;
    }

    public State[] buildStatesList(State state) {
        State s = state;
        int count = 0;
        while (s != null) {
            ++count;
            s = s.predecessor;
        }
        State[] states = new State[count];
        while (state != null) {
            states[--count] = state;
            state = state.predecessor;
        }
        return states;
    }
}

