package nintaco.gui.table;

import java.awt.*;
import nintaco.gui.*;
import static nintaco.util.GuiUtil.*;

public class TableDialog extends javax.swing.JDialog {

  public TableDialog(Window parent) {
    super(parent);
    setModal(true);    
    initComponents();
    table.getSelectionModel().addListSelectionListener(e -> selectionChanged());
    initialize();
    selectionChanged();
    updateClearButton();
    getRootPane().setDefaultButton(okButton);
    scaleFonts(this);
    pack();
    setLocationRelativeTo(parent);
  }
  
  protected void closeDialog() {
    dispose();
  }
  
  protected void initialize() {    
  }
  
  protected void updateClearButton() {
    clearButton.setEnabled(table.getModel().getRowCount() > 0);
  }
  
  protected void setSelectedRow(final int rowIndex) {
    if (rowIndex >= 0 && rowIndex < table.getModel().getRowCount()) {
      final int index = table.convertRowIndexToView(rowIndex);
      table.setRowSelectionInterval(index, index);
    }
  }
  
  protected int getSelectedRowIndex() {
    final int index = table.getSelectedRow();
    return (index >= 0 && index < table.getModel().getRowCount()) 
        ? table.convertRowIndexToModel(index) : index;
  }
  
  protected void selectionChanged() {
    final int index = getSelectedRowIndex();
    final boolean enabled = index >= 0 
        && index < table.getModel().getRowCount();
    editButton.setEnabled(enabled);
    deleteButton.setEnabled(enabled);    
  }
  
  protected void newButtonPressed() {    
  }
  
  protected void editButtonPressed(final int index) {    
  }
  
  protected void deleteButtonPressed(final int index) {    
  }
  
  protected void importButtonPressed() {    
  }
  
  protected void exportButtonPressed() {    
  }
  
  protected void clearButtonPressed() {    
  }
  
  protected void cancelButtonPressed() {    
  }
  
  protected void okButtonPressed() {    
  }
  
  protected void handleShown() {    
  }

  /**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    scrollPane = new javax.swing.JScrollPane();
    table = new ToolTipsTable();
    newButton = new javax.swing.JButton();
    editButton = new javax.swing.JButton();
    deleteButton = new javax.swing.JButton();
    importButton = new javax.swing.JButton();
    exportButton = new javax.swing.JButton();
    clearButton = new javax.swing.JButton();
    cancelButton = new javax.swing.JButton();
    okButton = new javax.swing.JButton();

    setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
    setMaximumSize(null);
    setMinimumSize(null);
    setPreferredSize(null);
    addComponentListener(new java.awt.event.ComponentAdapter() {
      public void componentShown(java.awt.event.ComponentEvent evt) {
        formComponentShown(evt);
      }
    });
    addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent evt) {
        formWindowClosing(evt);
      }
    });

    scrollPane.setMaximumSize(null);

    table.setModel(new javax.swing.table.DefaultTableModel(
      new Object [][] {

      },
      new String [] {

      }
    ));
    table.setAutoResizeMode(javax.swing.JTable.AUTO_RESIZE_LAST_COLUMN);
    table.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
    scrollPane.setViewportView(table);

    newButton.setMnemonic('N');
    newButton.setText("New...");
    newButton.setFocusPainted(false);
    newButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        newButtonActionPerformed(evt);
      }
    });

    editButton.setMnemonic('E');
    editButton.setText("Edit...");
    editButton.setFocusPainted(false);
    editButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        editButtonActionPerformed(evt);
      }
    });

    deleteButton.setMnemonic('D');
    deleteButton.setText("Delete");
    deleteButton.setFocusPainted(false);
    deleteButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        deleteButtonActionPerformed(evt);
      }
    });

    importButton.setMnemonic('I');
    importButton.setText("Import...");
    importButton.setFocusPainted(false);
    importButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        importButtonActionPerformed(evt);
      }
    });

    exportButton.setMnemonic('x');
    exportButton.setText("Export...");
    exportButton.setFocusPainted(false);
    exportButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        exportButtonActionPerformed(evt);
      }
    });

    clearButton.setMnemonic('r');
    clearButton.setText("Clear");
    clearButton.setFocusPainted(false);
    clearButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        clearButtonActionPerformed(evt);
      }
    });

    cancelButton.setMnemonic('C');
    cancelButton.setText("Cancel");
    cancelButton.setFocusPainted(false);
    cancelButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        cancelButtonActionPerformed(evt);
      }
    });

    okButton.setMnemonic('O');
    okButton.setText("OK");
    okButton.setFocusPainted(false);
    okButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        okButtonActionPerformed(evt);
      }
    });

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(scrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
          .addGroup(layout.createSequentialGroup()
            .addComponent(newButton)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(editButton)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(deleteButton)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(importButton)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(exportButton)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(clearButton)
            .addGap(0, 0, Short.MAX_VALUE))
          .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
            .addGap(0, 0, Short.MAX_VALUE)
            .addComponent(okButton)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(cancelButton)))
        .addContainerGap())
    );

    layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {cancelButton, clearButton, deleteButton, editButton, exportButton, importButton, newButton, okButton});

    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addComponent(scrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(newButton)
          .addComponent(editButton)
          .addComponent(deleteButton)
          .addComponent(importButton)
          .addComponent(exportButton)
          .addComponent(clearButton))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(cancelButton)
          .addComponent(okButton))
        .addContainerGap())
    );
  }// </editor-fold>//GEN-END:initComponents

  private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
    closeDialog();
  }//GEN-LAST:event_formWindowClosing

  private void newButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_newButtonActionPerformed
    newButtonPressed();
    updateClearButton();
  }//GEN-LAST:event_newButtonActionPerformed

  private void editButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editButtonActionPerformed
    final int index = getSelectedRowIndex();
    if (index >= 0 && index < table.getModel().getRowCount()) {
      editButtonPressed(index);
    }    
  }//GEN-LAST:event_editButtonActionPerformed

  private void deleteButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_deleteButtonActionPerformed
    final int index = getSelectedRowIndex();
    if (index >= 0 && index < table.getModel().getRowCount()) {
      deleteButtonPressed(index);
    }
    updateClearButton();
  }//GEN-LAST:event_deleteButtonActionPerformed

  private void importButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_importButtonActionPerformed
    importButtonPressed();
  }//GEN-LAST:event_importButtonActionPerformed

  private void exportButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exportButtonActionPerformed
    exportButtonPressed();
  }//GEN-LAST:event_exportButtonActionPerformed

  private void clearButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clearButtonActionPerformed
    clearButtonPressed();
    updateClearButton();
  }//GEN-LAST:event_clearButtonActionPerformed

  private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
    cancelButtonPressed();
  }//GEN-LAST:event_cancelButtonActionPerformed

  private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
    if (table.isEditing()) {
      table.getCellEditor().stopCellEditing();
    }
    okButtonPressed();
  }//GEN-LAST:event_okButtonActionPerformed

  private void formComponentShown(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_formComponentShown
    handleShown();
  }//GEN-LAST:event_formComponentShown

  // Variables declaration - do not modify//GEN-BEGIN:variables
  protected javax.swing.JButton cancelButton;
  protected javax.swing.JButton clearButton;
  protected javax.swing.JButton deleteButton;
  protected javax.swing.JButton editButton;
  protected javax.swing.JButton exportButton;
  protected javax.swing.JButton importButton;
  protected javax.swing.JButton newButton;
  protected javax.swing.JButton okButton;
  protected javax.swing.JScrollPane scrollPane;
  protected javax.swing.JTable table;
  // End of variables declaration//GEN-END:variables

}
