package nintaco.gui.sound;

import java.awt.*;
import javax.swing.*;
import nintaco.apu.SystemAudioProcessor;
import nintaco.preferences.*;
import static nintaco.util.GuiUtil.*;
import static nintaco.util.StringUtil.*;

public class SoundOptionsDialog extends javax.swing.JDialog {

  public SoundOptionsDialog(final Window parent) {
    super(parent);
    setModal(true);
    initComponents();
    loadFields();
    scaleFonts(this);
    pack();
    setLocationRelativeTo(parent);
    okButton.requestFocus();
  }
  
  private void loadFields() {
    setSoundPrefs(AppPrefs.getInstance().getSoundPrefs());    
  }
  
  private void setSoundPrefs(final SoundPrefs prefs) {  
    
    final String[] audioDevices = SystemAudioProcessor.getAudioDevices();
    deviceComboBox.setModel(new DefaultComboBoxModel<>(audioDevices));
    
    int deviceIndex = 0;
    final String audioDevice = prefs.getAudioDevice();
    if (isBlank(audioDevice) || (deviceIndex = findMatch(audioDevices, 
        audioDevice)) < 0) {
      deviceIndex = SystemAudioProcessor.getDefaultAudioDevice(audioDevices);
    }
    deviceComboBox.setSelectedIndex(deviceIndex);
    
    latencySpinner.setValue(prefs.getLatencyMillis());
  }
  
  private void saveFields() {
    final SoundPrefs prefs = AppPrefs.getInstance().getSoundPrefs();
    prefs.setAudioDevice((String)deviceComboBox.getSelectedItem());
    prefs.setLatencyMillis((int)latencySpinner.getValue());
    AppPrefs.save();
    SystemAudioProcessor.applySoundPrefs(prefs);
  }
  
  private void closeDialog() {
    dispose();
  }

  /**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    cancelButton = new javax.swing.JButton();
    okButton = new javax.swing.JButton();
    deviceLabel = new javax.swing.JLabel();
    deviceComboBox = new javax.swing.JComboBox<>();
    latencyLabel = new javax.swing.JLabel();
    latencySpinner = new javax.swing.JSpinner();

    setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
    setTitle("Sound Options");
    setMaximumSize(null);
    setMinimumSize(null);
    setPreferredSize(null);
    addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent evt) {
        formWindowClosing(evt);
      }
    });

    cancelButton.setMnemonic('C');
    cancelButton.setText(" Cancel ");
    cancelButton.setFocusPainted(false);
    cancelButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        cancelButtonActionPerformed(evt);
      }
    });

    okButton.setMnemonic('O');
    okButton.setText("OK");
    okButton.setFocusPainted(false);
    okButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        okButtonActionPerformed(evt);
      }
    });

    deviceLabel.setText("Device:");
    deviceLabel.setMaximumSize(null);
    deviceLabel.setMinimumSize(null);
    deviceLabel.setPreferredSize(null);

    deviceComboBox.setModel(new javax.swing.DefaultComboBoxModel<>(new String[] { "None" }));
    deviceComboBox.setFocusable(false);
    deviceComboBox.setMaximumSize(null);
    deviceComboBox.setMinimumSize(null);
    deviceComboBox.setPreferredSize(null);

    latencyLabel.setText("Latency (ms):");

    latencySpinner.setModel(new javax.swing.SpinnerNumberModel(50, 20, 500, 1));
    latencySpinner.setFocusable(false);
    latencySpinner.setMaximumSize(null);

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addGroup(layout.createSequentialGroup()
            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
              .addComponent(deviceLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
              .addComponent(latencyLabel))
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
              .addComponent(latencySpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
              .addComponent(deviceComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
            .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
          .addGroup(layout.createSequentialGroup()
            .addGap(0, 0, Short.MAX_VALUE)
            .addComponent(okButton)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(cancelButton)
            .addGap(10, 10, 10))))
    );

    layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {cancelButton, okButton});

    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(deviceLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(deviceComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(latencyLabel)
          .addComponent(latencySpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addGap(18, 18, Short.MAX_VALUE)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(cancelButton)
          .addComponent(okButton))
        .addGap(15, 15, 15))
    );
  }// </editor-fold>//GEN-END:initComponents

  private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
    saveFields();
    closeDialog();
  }//GEN-LAST:event_okButtonActionPerformed

  private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
    closeDialog();
  }//GEN-LAST:event_cancelButtonActionPerformed

  private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
    closeDialog();
  }//GEN-LAST:event_formWindowClosing

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JButton cancelButton;
  private javax.swing.JComboBox<String> deviceComboBox;
  private javax.swing.JLabel deviceLabel;
  private javax.swing.JLabel latencyLabel;
  private javax.swing.JSpinner latencySpinner;
  private javax.swing.JButton okButton;
  // End of variables declaration//GEN-END:variables
}
