package nintaco.gui.rob;

import java.awt.*;
import nintaco.*;
import nintaco.input.*;
import nintaco.input.other.*;
import static nintaco.gui.rob.RobGame.*;
import static nintaco.util.GuiUtil.*;

public class RobFrame extends javax.swing.JFrame {

  private final GyromitePane gyromitePane = new GyromitePane();
  private final StackUpPane stackUpPane = new StackUpPane();
  
  private volatile int game;
  
  public RobFrame(final int game) {
    this.game = game;
    initComponents();    
    scaleFonts(this);
    setContentPane(game == GYROMITE ? gyromitePane : stackUpPane);
    pack();
    moveToImageFrameMonitor(this);
  }
  
  public void setGame(final int game) {
    if (this.game != game) {
      this.game = game;
      if (game != NONE) {
        setContentPane(game == GYROMITE ? gyromitePane : stackUpPane);
        repaint();
      }
    }
  }
  
  public void render(final RobState state) {  
    final int robGame = state.game;
    if (game != robGame) {      
      EventQueue.invokeLater(() -> setGame(robGame));
    }
    switch(robGame) {
      case GYROMITE:
        gyromitePane.render(state);
        break;
      case STACK_UP:      
        stackUpPane.render(state);
        break;
    }
  }
  
  public void destroy() {
    dispose();
  }
  
  /**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
    setTitle("Robotic Operating Buddy");
    setPreferredSize(null);
    addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent evt) {
        formWindowClosing(evt);
      }
    });

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGap(0, 400, Short.MAX_VALUE)
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGap(0, 300, Short.MAX_VALUE)
    );
  }// </editor-fold>//GEN-END:initComponents

  private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
    //App.destroyRobFrame();
    setVisible(false);
  }//GEN-LAST:event_formWindowClosing


  // Variables declaration - do not modify//GEN-BEGIN:variables
  // End of variables declaration//GEN-END:variables
}
