package nintaco.gui.ramwatch;

import javax.swing.*;
import static nintaco.util.GuiUtil.*;
import static nintaco.util.StringUtil.*;

public class EditRamWatchDialog extends javax.swing.JDialog {

  private final RamWatchRow row = new RamWatchRow();
  
  private JRadioButton[] wordSizeRadioButtons;
  private JRadioButton[] formatRadioButtons;
  private RamWatchRow result;
  
  public EditRamWatchDialog(java.awt.Frame parent) {
    super(parent, true);
    initComponents();
    initRadioButtons();
    getRootPane().setDefaultButton(okButton);
    initTextFields();
    setValues();
    updateOkButton();
    scaleFonts(this);
    pack();
    hiddenButton.setVisible(false);
    setLocationRelativeTo(parent);
  }
  
  public RamWatchRow getResult() {
    return result;
  }
  
  private void initRadioButtons() {
    wordSizeRadioButtons = new JRadioButton[] {
      byte1RadioButton,
      byte2RadioButton,
      byte4RadioButton,
    };
    for(int i = wordSizeRadioButtons.length - 1; i >= 0; i--) {
      final int wordSizeIndex = i;
      wordSizeRadioButtons[i].addActionListener(
          e -> row.setWordSizeIndex(wordSizeIndex));
    }
    formatRadioButtons = new JRadioButton[] {
      signedRadioButton,
      unsignedRadioButton,
      hexRadioButton,
    };
    for(int i = formatRadioButtons.length - 1; i >= 0; i--) {
      final int valueFormat = i;
      formatRadioButtons[i].addActionListener(
          e -> row.setValueFormat(valueFormat));
    }
  }
  
  private void initTextFields() {
    addLoseFocusListener(this, addressTextField);
    addLoseFocusListener(this, descriptionTextField);
    addressTextField.getDocument().addDocumentListener(createDocumentListener(
        this::addressTextFieldChanged));    
  }
  
  private void addressTextFieldChanged() {
    row.setAddress(parseInt(addressTextField.getText(), true, 0xFFFF));
    updateOkButton();
  }
  
  private void updateOkButton() {
    okButton.setEnabled(row.getAddress() >= 0);
  }
  
  private void closeDialog() {
    dispose();
  }
  
  private void captureValues() {
    row.setAddress(parseInt(addressTextField.getText(), true, 0xFFFF));
    row.setDescription(descriptionTextField.getText().trim());    
  }
  
  private void setValues() {
    addressTextField.setText(String.format("$%04X", row.getAddress()));
    descriptionTextField.setText(row.getDescription());
    wordSizeRadioButtons[row.getWordSizeIndex()].setSelected(true);
    formatRadioButtons[row.getValueFormat()].setSelected(true);
    if (row.getAddress() == 0) {
      addressTextField.selectAll();
      addressTextField.requestFocus();
    } else {
      descriptionTextField.requestFocus();
    }
  }
  
  public void setRamWatchRow(final RamWatchRow row) {
    this.row.set(row);
    setValues();
  }

  /**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    wordSizeButtonGroup = new javax.swing.ButtonGroup();
    formatButtonGroup = new javax.swing.ButtonGroup();
    addressLabel = new javax.swing.JLabel();
    descriptionLabel = new javax.swing.JLabel();
    addressTextField = new javax.swing.JTextField();
    descriptionTextField = new javax.swing.JTextField();
    cancelButton = new javax.swing.JButton();
    okButton = new javax.swing.JButton();
    jPanel1 = new javax.swing.JPanel();
    byte1RadioButton = new javax.swing.JRadioButton();
    byte2RadioButton = new javax.swing.JRadioButton();
    byte4RadioButton = new javax.swing.JRadioButton();
    jPanel2 = new javax.swing.JPanel();
    signedRadioButton = new javax.swing.JRadioButton();
    unsignedRadioButton = new javax.swing.JRadioButton();
    hexRadioButton = new javax.swing.JRadioButton();
    hiddenButton = new javax.swing.JButton();

    setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
    setMaximumSize(null);
    setMinimumSize(null);
    setPreferredSize(null);
    addComponentListener(new java.awt.event.ComponentAdapter() {
      public void componentShown(java.awt.event.ComponentEvent evt) {
        formComponentShown(evt);
      }
    });
    addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent evt) {
        formWindowClosing(evt);
      }
    });

    addressLabel.setText("Address:");
    addressLabel.setMaximumSize(null);
    addressLabel.setMinimumSize(null);
    addressLabel.setPreferredSize(null);

    descriptionLabel.setText("Description:");
    descriptionLabel.setMaximumSize(null);
    descriptionLabel.setMinimumSize(null);
    descriptionLabel.setPreferredSize(null);

    addressTextField.setColumns(6);
    addressTextField.setMaximumSize(null);
    addressTextField.setMinimumSize(null);
    addressTextField.setPreferredSize(null);

    descriptionTextField.setColumns(32);
    descriptionTextField.setMaximumSize(null);
    descriptionTextField.setMinimumSize(null);
    descriptionTextField.setPreferredSize(null);

    cancelButton.setMnemonic('C');
    cancelButton.setText("  Cancel  ");
    cancelButton.setFocusPainted(false);
    cancelButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        cancelButtonActionPerformed(evt);
      }
    });

    okButton.setMnemonic('O');
    okButton.setText("OK");
    okButton.setFocusPainted(false);
    okButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        okButtonActionPerformed(evt);
      }
    });

    jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Word Size"));
    jPanel1.setMaximumSize(null);

    wordSizeButtonGroup.add(byte1RadioButton);
    byte1RadioButton.setSelected(true);
    byte1RadioButton.setText("1 Byte");
    byte1RadioButton.setFocusPainted(false);

    wordSizeButtonGroup.add(byte2RadioButton);
    byte2RadioButton.setText("2 Bytes");
    byte2RadioButton.setFocusPainted(false);

    wordSizeButtonGroup.add(byte4RadioButton);
    byte4RadioButton.setText("4 Bytes");
    byte4RadioButton.setFocusPainted(false);

    javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
    jPanel1.setLayout(jPanel1Layout);
    jPanel1Layout.setHorizontalGroup(
      jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(jPanel1Layout.createSequentialGroup()
        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(byte1RadioButton)
          .addComponent(byte2RadioButton)
          .addComponent(byte4RadioButton))
        .addContainerGap())
    );
    jPanel1Layout.setVerticalGroup(
      jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(jPanel1Layout.createSequentialGroup()
        .addComponent(byte1RadioButton)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(byte2RadioButton)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(byte4RadioButton)
        .addContainerGap())
    );

    jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("Format"));
    jPanel2.setMaximumSize(null);

    formatButtonGroup.add(signedRadioButton);
    signedRadioButton.setSelected(true);
    signedRadioButton.setText("Signed");
    signedRadioButton.setFocusPainted(false);

    formatButtonGroup.add(unsignedRadioButton);
    unsignedRadioButton.setText("Unsigned");
    unsignedRadioButton.setFocusPainted(false);

    formatButtonGroup.add(hexRadioButton);
    hexRadioButton.setText("Hex");
    hexRadioButton.setFocusPainted(false);

    javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
    jPanel2.setLayout(jPanel2Layout);
    jPanel2Layout.setHorizontalGroup(
      jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(jPanel2Layout.createSequentialGroup()
        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(signedRadioButton)
          .addComponent(unsignedRadioButton)
          .addComponent(hexRadioButton))
        .addContainerGap())
    );
    jPanel2Layout.setVerticalGroup(
      jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(jPanel2Layout.createSequentialGroup()
        .addComponent(signedRadioButton)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(unsignedRadioButton)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(hexRadioButton)
        .addContainerGap())
    );

    hiddenButton.setMnemonic('H');
    hiddenButton.setText("Hidden Button");
    hiddenButton.setFocusPainted(false);

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addGroup(layout.createSequentialGroup()
            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
              .addComponent(addressLabel, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
              .addComponent(descriptionLabel, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
              .addGroup(layout.createSequentialGroup()
                .addComponent(addressTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 0, Short.MAX_VALUE))
              .addComponent(descriptionTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 1, Short.MAX_VALUE)))
          .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
            .addGap(0, 0, Short.MAX_VALUE)
            .addComponent(hiddenButton)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(okButton)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(cancelButton))
          .addGroup(layout.createSequentialGroup()
            .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
            .addGap(0, 0, Short.MAX_VALUE)))
        .addContainerGap())
    );

    layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {cancelButton, okButton});

    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(addressLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(addressTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(descriptionLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(descriptionTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addGap(18, 18, Short.MAX_VALUE)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(cancelButton)
          .addComponent(okButton)
          .addComponent(hiddenButton))
        .addContainerGap())
    );
  }// </editor-fold>//GEN-END:initComponents

  private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
    closeDialog();
  }//GEN-LAST:event_formWindowClosing

  private void formComponentShown(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_formComponentShown
    addressTextField.setText(String.format("$%04X", row.getAddress()));
    descriptionTextField.setText(row.getDescription());
  }//GEN-LAST:event_formComponentShown

  private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
    captureValues();
    result = row;
    closeDialog();
  }//GEN-LAST:event_okButtonActionPerformed

  private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
    closeDialog();
  }//GEN-LAST:event_cancelButtonActionPerformed

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JLabel addressLabel;
  private javax.swing.JTextField addressTextField;
  private javax.swing.JRadioButton byte1RadioButton;
  private javax.swing.JRadioButton byte2RadioButton;
  private javax.swing.JRadioButton byte4RadioButton;
  private javax.swing.JButton cancelButton;
  private javax.swing.JLabel descriptionLabel;
  private javax.swing.JTextField descriptionTextField;
  private javax.swing.ButtonGroup formatButtonGroup;
  private javax.swing.JRadioButton hexRadioButton;
  private javax.swing.JButton hiddenButton;
  private javax.swing.JPanel jPanel1;
  private javax.swing.JPanel jPanel2;
  private javax.swing.JButton okButton;
  private javax.swing.JRadioButton signedRadioButton;
  private javax.swing.JRadioButton unsignedRadioButton;
  private javax.swing.ButtonGroup wordSizeButtonGroup;
  // End of variables declaration//GEN-END:variables
}
