package nintaco.gui.overscan;

import java.awt.*;
import nintaco.tv.*;
import static nintaco.util.GuiUtil.*;

public class OverscanPanel extends javax.swing.JPanel {

  public OverscanPanel() {
    initComponents();
  }
  
  public void init(final Window window) {
    addLoseFocusListener(window, topSpinner);
    addLoseFocusListener(window, bottomSpinner);
    addLoseFocusListener(window, leftSpinner);
    addLoseFocusListener(window, rightSpinner);
  }
  
  public void setScreenBorders(final ScreenBorders borders) {
    setTop(borders.getTop());
    setBottom(borders.getBottom());
    setLeft(borders.getLeft());
    setRight(borders.getRight());
  }
  
  public ScreenBorders getScreenBorders() {
    return new ScreenBorders(getTop(), getBottom(), getLeft(), getRight());
  }
  
  public void setTop(final int top) {
    topSpinner.setValue(top);
  }
  
  public int getTop() {
    return (int)topSpinner.getValue();
  }
  
  public void setBottom(final int bottom) {
    bottomSpinner.setValue(bottom);
  }
  
  public int getBottom() {
    return (int)bottomSpinner.getValue();
  }

  public void setLeft(final int left) {
    leftSpinner.setValue(left);
  }
  
  public int getLeft() {
    return (int)leftSpinner.getValue();
  }

  public void setRight(final int right) {
    rightSpinner.setValue(right);
  }
  
  public int getRight() {
    return (int)rightSpinner.getValue();
  }  
  
  /**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    topLabel = new javax.swing.JLabel();
    bottomLabel = new javax.swing.JLabel();
    leftLabel = new javax.swing.JLabel();
    rightLabel = new javax.swing.JLabel();
    topSpinner = new javax.swing.JSpinner();
    bottomSpinner = new javax.swing.JSpinner();
    leftSpinner = new javax.swing.JSpinner();
    rightSpinner = new javax.swing.JSpinner();

    topLabel.setText("Top:");

    bottomLabel.setText("Bottom:");

    leftLabel.setText("Left:");

    rightLabel.setText("Right:");

    topSpinner.setModel(new javax.swing.SpinnerNumberModel(0, 0, 120, 1));

    bottomSpinner.setModel(new javax.swing.SpinnerNumberModel(0, 0, 120, 1));

    leftSpinner.setModel(new javax.swing.SpinnerNumberModel(0, 0, 128, 1));

    rightSpinner.setModel(new javax.swing.SpinnerNumberModel(0, 0, 128, 1));

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
    this.setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(topLabel)
          .addComponent(bottomLabel)
          .addComponent(leftLabel)
          .addComponent(rightLabel))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(topSpinner)
          .addComponent(bottomSpinner)
          .addComponent(leftSpinner)
          .addComponent(rightSpinner))
        .addContainerGap())
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(topLabel)
          .addComponent(topSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(bottomLabel)
          .addComponent(bottomSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(leftLabel)
          .addComponent(leftSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(rightLabel)
          .addComponent(rightSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
    );
  }// </editor-fold>//GEN-END:initComponents


  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JLabel bottomLabel;
  private javax.swing.JSpinner bottomSpinner;
  private javax.swing.JLabel leftLabel;
  private javax.swing.JSpinner leftSpinner;
  private javax.swing.JLabel rightLabel;
  private javax.swing.JSpinner rightSpinner;
  private javax.swing.JLabel topLabel;
  private javax.swing.JSpinner topSpinner;
  // End of variables declaration//GEN-END:variables
}
