package nintaco.gui.overscan;

import java.awt.*;
import nintaco.App;
import nintaco.preferences.*;
import static nintaco.tv.TVSystem.*;
import static nintaco.util.GuiUtil.*;

public class OverscanDialog extends javax.swing.JDialog {

  public OverscanDialog(final Window parent) {
    super(parent);
    setModal(true);
    initComponents();
    initOverscanPanels();
    loadFields();    
    scaleFonts(this);
    pack();
    setLocationRelativeTo(parent);
    okButton.requestFocus();
  }
  
  private void initOverscanPanels() {
    ntscPanel.init(this);
    palPanel.init(this);
    dendyPanel.init(this);
  }
  
  private void loadFields() {
    final OverscanPrefs prefs = AppPrefs.getInstance().getOverscanPrefs();
    ntscPanel.setScreenBorders(prefs.getNtscBorders());
    palPanel.setScreenBorders(prefs.getPalBorders());
    dendyPanel.setScreenBorders(prefs.getDendyBorders());
  }
  
  private void captureFields() {
    final OverscanPrefs prefs = AppPrefs.getInstance().getOverscanPrefs();
    prefs.setNtscBorders(ntscPanel.getScreenBorders());
    prefs.setPalBorders(palPanel.getScreenBorders());
    prefs.setDendyBorders(dendyPanel.getScreenBorders());
  }
  
  private void closeDialog() {
    dispose();
  }

  /**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    cancelButton = new javax.swing.JButton();
    okButton = new javax.swing.JButton();
    ntscPanel = new nintaco.gui.overscan.OverscanPanel();
    palPanel = new nintaco.gui.overscan.OverscanPanel();
    dendyPanel = new nintaco.gui.overscan.OverscanPanel();
    defaultsButton = new javax.swing.JButton();

    setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
    setTitle("Overscan");
    addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent evt) {
        formWindowClosing(evt);
      }
    });

    cancelButton.setMnemonic('C');
    cancelButton.setText(" Cancel ");
    cancelButton.setFocusPainted(false);
    cancelButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        cancelButtonActionPerformed(evt);
      }
    });

    okButton.setMnemonic('O');
    okButton.setText("OK");
    okButton.setFocusPainted(false);
    okButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        okButtonActionPerformed(evt);
      }
    });

    ntscPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("NTSC"));

    palPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("PAL"));

    dendyPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Dendy"));

    defaultsButton.setMnemonic('D');
    defaultsButton.setText("Defaults");
    defaultsButton.setFocusPainted(false);
    defaultsButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        defaultsButtonActionPerformed(evt);
      }
    });

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addGroup(layout.createSequentialGroup()
            .addGap(0, 0, Short.MAX_VALUE)
            .addComponent(defaultsButton)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(okButton)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(cancelButton))
          .addGroup(layout.createSequentialGroup()
            .addComponent(ntscPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(palPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(dendyPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
        .addContainerGap())
    );

    layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {cancelButton, defaultsButton, okButton});

    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(ntscPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
          .addComponent(palPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
          .addComponent(dendyPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        .addGap(18, 18, 18)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(cancelButton)
          .addComponent(okButton)
          .addComponent(defaultsButton))
        .addContainerGap())
    );
  }// </editor-fold>//GEN-END:initComponents

  private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
    captureFields();
    App.getImageFrame().getImagePane().updateScreenBorders();
    AppPrefs.save();
    closeDialog();
  }//GEN-LAST:event_okButtonActionPerformed

  private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
    closeDialog();
  }//GEN-LAST:event_cancelButtonActionPerformed

  private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
    closeDialog();
  }//GEN-LAST:event_formWindowClosing

  private void defaultsButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_defaultsButtonActionPerformed
    ntscPanel.setScreenBorders(NTSC.getScreenBorders());
    palPanel.setScreenBorders(PAL.getScreenBorders());
    dendyPanel.setScreenBorders(Dendy.getScreenBorders());
  }//GEN-LAST:event_defaultsButtonActionPerformed

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JButton cancelButton;
  private javax.swing.JButton defaultsButton;
  private nintaco.gui.overscan.OverscanPanel dendyPanel;
  private nintaco.gui.overscan.OverscanPanel ntscPanel;
  private javax.swing.JButton okButton;
  private nintaco.gui.overscan.OverscanPanel palPanel;
  // End of variables declaration//GEN-END:variables
}
