package nintaco.gui.input.settings;

import java.awt.*;
import java.util.*;
import javax.swing.*;
import nintaco.input.*;
import nintaco.preferences.*;
import static nintaco.util.GuiUtil.*;

public class InputSettingsDialog extends javax.swing.JDialog {

  public InputSettingsDialog(final Window parent) {
    super(parent);
    setModal(true);
    initComponents();
    initSpinner();
    initAutofireSlider();
    loadFields();
    scaleFonts(this);        
    pack();
    setLocationRelativeTo(parent);
  }
  
  private void initSpinner() {
    zapperLightDetectionMarginSpinner.setModel(
        new SpinnerNumberModel(3, 0, 7, 1));
    zapperLightDetectionMarginSpinner.setEditor(new JSpinner.NumberEditor(
        zapperLightDetectionMarginSpinner, "#"));
    addLoseFocusListener(this, zapperLightDetectionMarginSpinner);
  }
  
  private void initAutofireSlider() {
    final Hashtable<Integer, JLabel> labelTable = new Hashtable<>();
    labelTable.put(7, new JLabel("Slow"));
    labelTable.put(4, new JLabel("Medium"));
    labelTable.put(1, new JLabel("Fast"));
    autofireSlider.setLabelTable(labelTable);
  }

  private void closeDialog() {
    dispose();
  }
  
  private void loadFields() {
    loadFields(AppPrefs.getInstance().getInputs());    
  }
  
  private void loadFields(final Inputs inputs) {
    autofireSlider.setValue(inputs.getAutofireRate());
    impossibleInputCheckBox.setSelected(inputs.isAllowImpossibleInput());
    crosshairsCheckBox.setSelected(inputs.isShowZapperCrosshairs());
    hideInactiveMouseCheckBox.setSelected(inputs.isHideInactiveMouse());
    hideFullscreenMouseCheckBox.setSelected(inputs.isHideFullscreenMouse());
    exchangeGlassesCheckBox.setSelected(inputs.isExchangeGlasses());
    disableKeyboardRewindTimeCheckBox.setSelected(inputs
        .isDisableKeyboardRewindTime());
    zapperLightDetectionMarginSpinner.setValue(inputs
        .getZapperLightDetectionMargin());
    
    switch(inputs.getHighSpeedRate()) {
      case 200:
        highSpeed200RadioButton.setSelected(true);
        break;
      case 300:
        highSpeed300RadioButton.setSelected(true);
        break;
      case 400:
        highSpeed400RadioButton.setSelected(true);
        break;
      default:
        highSpeedMaxRadioButton.setSelected(true);
        break;
    }
  }
  
  /**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    speedUpButtonGroup = new javax.swing.ButtonGroup();
    autofirePanel = new javax.swing.JPanel();
    autofireSlider = new javax.swing.JSlider();
    impossibleInputCheckBox = new javax.swing.JCheckBox();
    crosshairsCheckBox = new javax.swing.JCheckBox();
    cancelButton = new javax.swing.JButton();
    okButton = new javax.swing.JButton();
    hideCursorCheckBox = new javax.swing.JCheckBox();
    hideInactiveMouseCheckBox = new javax.swing.JCheckBox();
    hideFullscreenMouseCheckBox = new javax.swing.JCheckBox();
    autofireResetButton = new javax.swing.JButton();
    exchangeGlassesCheckBox = new javax.swing.JCheckBox();
    disableKeyboardRewindTimeCheckBox = new javax.swing.JCheckBox();
    highSpeedPanel = new javax.swing.JPanel();
    highSpeed200RadioButton = new javax.swing.JRadioButton();
    highSpeed300RadioButton = new javax.swing.JRadioButton();
    highSpeed400RadioButton = new javax.swing.JRadioButton();
    highSpeedMaxRadioButton = new javax.swing.JRadioButton();
    zapperLightDetectionMarginLabel = new javax.swing.JLabel();
    zapperLightDetectionMarginSpinner = new javax.swing.JSpinner();

    setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
    setTitle("Input Settings");
    setMaximumSize(null);
    setMinimumSize(null);
    setPreferredSize(null);
    addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent evt) {
        formWindowClosing(evt);
      }
    });

    autofirePanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Autofire Rate"));
    autofirePanel.setMaximumSize(null);

    autofireSlider.setMajorTickSpacing(1);
    autofireSlider.setMaximum(7);
    autofireSlider.setMinimum(1);
    autofireSlider.setMinorTickSpacing(1);
    autofireSlider.setPaintLabels(true);
    autofireSlider.setPaintTicks(true);
    autofireSlider.setSnapToTicks(true);
    autofireSlider.setValue(4);
    autofireSlider.setFocusable(false);
    autofireSlider.setInverted(true);

    javax.swing.GroupLayout autofirePanelLayout = new javax.swing.GroupLayout(autofirePanel);
    autofirePanel.setLayout(autofirePanelLayout);
    autofirePanelLayout.setHorizontalGroup(
      autofirePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(autofirePanelLayout.createSequentialGroup()
        .addContainerGap()
        .addComponent(autofireSlider, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        .addContainerGap())
    );
    autofirePanelLayout.setVerticalGroup(
      autofirePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(autofirePanelLayout.createSequentialGroup()
        .addContainerGap()
        .addComponent(autofireSlider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addContainerGap())
    );

    impossibleInputCheckBox.setText("Allow impossible Gamepad input (Left+Right and Up+Down)");
    impossibleInputCheckBox.setFocusPainted(false);

    crosshairsCheckBox.setText("Show crosshairs mouse cursor for Zapper");
    crosshairsCheckBox.setFocusPainted(false);

    cancelButton.setMnemonic('C');
    cancelButton.setText("Cancel");
    cancelButton.setFocusPainted(false);
    cancelButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        cancelButtonActionPerformed(evt);
      }
    });

    okButton.setMnemonic('O');
    okButton.setText("OK");
    okButton.setFocusPainted(false);
    okButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        okButtonActionPerformed(evt);
      }
    });

    hideCursorCheckBox.setText("Hide cursor for mouse controllers");
    hideCursorCheckBox.setFocusPainted(false);

    hideInactiveMouseCheckBox.setText("Hide mouse cursor when inactive");
    hideInactiveMouseCheckBox.setFocusPainted(false);
    hideInactiveMouseCheckBox.setPreferredSize(null);

    hideFullscreenMouseCheckBox.setText("Hide mouse cursor in fullscreen mode");
    hideFullscreenMouseCheckBox.setFocusPainted(false);
    hideFullscreenMouseCheckBox.setPreferredSize(null);

    autofireResetButton.setMnemonic('D');
    autofireResetButton.setText("Defaults");
    autofireResetButton.setFocusPainted(false);
    autofireResetButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        autofireResetButtonActionPerformed(evt);
      }
    });

    exchangeGlassesCheckBox.setText("Exchange left and right Famicom 3D Glasses");
    exchangeGlassesCheckBox.setFocusPainted(false);

    disableKeyboardRewindTimeCheckBox.setText("Disable Rewind Time and High-speed for Keyboard devices");
    disableKeyboardRewindTimeCheckBox.setFocusPainted(false);

    highSpeedPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("High-speed Rate"));

    speedUpButtonGroup.add(highSpeed200RadioButton);
    highSpeed200RadioButton.setText("200%");
    highSpeed200RadioButton.setFocusPainted(false);
    highSpeed200RadioButton.setMaximumSize(null);
    highSpeed200RadioButton.setMinimumSize(null);
    highSpeed200RadioButton.setPreferredSize(null);

    speedUpButtonGroup.add(highSpeed300RadioButton);
    highSpeed300RadioButton.setText("300%");
    highSpeed300RadioButton.setFocusPainted(false);
    highSpeed300RadioButton.setMaximumSize(null);
    highSpeed300RadioButton.setMinimumSize(null);
    highSpeed300RadioButton.setPreferredSize(null);

    speedUpButtonGroup.add(highSpeed400RadioButton);
    highSpeed400RadioButton.setText("400%");
    highSpeed400RadioButton.setFocusPainted(false);
    highSpeed400RadioButton.setMaximumSize(null);
    highSpeed400RadioButton.setMinimumSize(null);
    highSpeed400RadioButton.setPreferredSize(null);

    speedUpButtonGroup.add(highSpeedMaxRadioButton);
    highSpeedMaxRadioButton.setText("Max");
    highSpeedMaxRadioButton.setFocusPainted(false);
    highSpeedMaxRadioButton.setMaximumSize(null);
    highSpeedMaxRadioButton.setMinimumSize(null);
    highSpeedMaxRadioButton.setPreferredSize(null);

    javax.swing.GroupLayout highSpeedPanelLayout = new javax.swing.GroupLayout(highSpeedPanel);
    highSpeedPanel.setLayout(highSpeedPanelLayout);
    highSpeedPanelLayout.setHorizontalGroup(
      highSpeedPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(highSpeedPanelLayout.createSequentialGroup()
        .addContainerGap()
        .addComponent(highSpeed200RadioButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(highSpeed300RadioButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(highSpeed400RadioButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(highSpeedMaxRadioButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
    );
    highSpeedPanelLayout.setVerticalGroup(
      highSpeedPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(highSpeedPanelLayout.createSequentialGroup()
        .addContainerGap()
        .addGroup(highSpeedPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(highSpeed200RadioButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(highSpeed300RadioButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(highSpeed400RadioButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(highSpeedMaxRadioButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
    );

    zapperLightDetectionMarginLabel.setText("Zapper light detection margin:");
    zapperLightDetectionMarginLabel.setMaximumSize(null);
    zapperLightDetectionMarginLabel.setMinimumSize(null);
    zapperLightDetectionMarginLabel.setPreferredSize(null);

    zapperLightDetectionMarginSpinner.setMaximumSize(null);
    zapperLightDetectionMarginSpinner.setMinimumSize(null);
    zapperLightDetectionMarginSpinner.setPreferredSize(null);

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(autofirePanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
          .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
            .addGap(0, 0, Short.MAX_VALUE)
            .addComponent(autofireResetButton)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(okButton)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(cancelButton))
          .addComponent(highSpeedPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
          .addGroup(layout.createSequentialGroup()
            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
              .addComponent(disableKeyboardRewindTimeCheckBox)
              .addComponent(exchangeGlassesCheckBox)
              .addComponent(hideFullscreenMouseCheckBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
              .addComponent(hideInactiveMouseCheckBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
              .addComponent(hideCursorCheckBox)
              .addComponent(crosshairsCheckBox)
              .addComponent(impossibleInputCheckBox)
              .addGroup(layout.createSequentialGroup()
                .addComponent(zapperLightDetectionMarginLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(zapperLightDetectionMarginSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
            .addGap(0, 0, Short.MAX_VALUE)))
        .addContainerGap())
    );

    layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {autofireResetButton, cancelButton, okButton});

    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addComponent(autofirePanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(highSpeedPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
        .addComponent(impossibleInputCheckBox)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(crosshairsCheckBox)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(hideCursorCheckBox)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(hideInactiveMouseCheckBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(hideFullscreenMouseCheckBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(exchangeGlassesCheckBox)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(disableKeyboardRewindTimeCheckBox)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(zapperLightDetectionMarginLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(zapperLightDetectionMarginSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addGap(18, 18, Short.MAX_VALUE)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(cancelButton)
          .addComponent(okButton)
          .addComponent(autofireResetButton))
        .addContainerGap())
    );
  }// </editor-fold>//GEN-END:initComponents

  private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
    closeDialog();
  }//GEN-LAST:event_formWindowClosing

  private void autofireResetButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_autofireResetButtonActionPerformed
    loadFields(new Inputs());
  }//GEN-LAST:event_autofireResetButtonActionPerformed

  private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
    final Inputs inputs = AppPrefs.getInstance().getInputs();
    inputs.setAutofireRate(autofireSlider.getValue());
    inputs.setAllowImpossibleInput(impossibleInputCheckBox.isSelected());    
    inputs.setShowZapperCrosshairs(crosshairsCheckBox.isSelected());
    inputs.setHideInactiveMouse(hideInactiveMouseCheckBox.isSelected());
    inputs.setHideFullscreenMouse(hideFullscreenMouseCheckBox.isSelected());
    inputs.setExchangeGlasses(exchangeGlassesCheckBox.isSelected()); 
    inputs.setDisableKeyboardRewindTime(disableKeyboardRewindTimeCheckBox
        .isSelected());
    inputs.setZapperLightDetectionMargin((int)zapperLightDetectionMarginSpinner
        .getValue());
        
    if (highSpeed200RadioButton.isSelected()) {
      inputs.setHighSpeedRate(200);
    } else if (highSpeed300RadioButton.isSelected()) {
      inputs.setHighSpeedRate(300);
    } else if (highSpeed400RadioButton.isSelected()) {
      inputs.setHighSpeedRate(400);
    } else {
      inputs.setHighSpeedRate(0);
    }
    
    closeDialog();
    InputUtil.handleSettingsChange();    
    inputs.apply();
    AppPrefs.save();
  }//GEN-LAST:event_okButtonActionPerformed

  private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
    closeDialog();
  }//GEN-LAST:event_cancelButtonActionPerformed

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JPanel autofirePanel;
  private javax.swing.JButton autofireResetButton;
  private javax.swing.JSlider autofireSlider;
  private javax.swing.JButton cancelButton;
  private javax.swing.JCheckBox crosshairsCheckBox;
  private javax.swing.JCheckBox disableKeyboardRewindTimeCheckBox;
  private javax.swing.JCheckBox exchangeGlassesCheckBox;
  private javax.swing.JCheckBox hideCursorCheckBox;
  private javax.swing.JCheckBox hideFullscreenMouseCheckBox;
  private javax.swing.JCheckBox hideInactiveMouseCheckBox;
  private javax.swing.JRadioButton highSpeed200RadioButton;
  private javax.swing.JRadioButton highSpeed300RadioButton;
  private javax.swing.JRadioButton highSpeed400RadioButton;
  private javax.swing.JRadioButton highSpeedMaxRadioButton;
  private javax.swing.JPanel highSpeedPanel;
  private javax.swing.JCheckBox impossibleInputCheckBox;
  private javax.swing.JButton okButton;
  private javax.swing.ButtonGroup speedUpButtonGroup;
  private javax.swing.JLabel zapperLightDetectionMarginLabel;
  private javax.swing.JSpinner zapperLightDetectionMarginSpinner;
  // End of variables declaration//GEN-END:variables
}
