package nintaco.gui.image;

import java.awt.*;
import nintaco.*;
import nintaco.mappers.nintendo.vs.*;
import static nintaco.util.GuiUtil.*;

public class SubMonitorFrame extends javax.swing.JFrame {

  private final ImagePane imagePane = new ImagePane();
  
  private boolean wasMaximized;
  
  public SubMonitorFrame() {
    initComponents();
    setContentPane(imagePane);
    scaleFonts(this);
    copyOtherImagePaneFields();
    pack();    
    
    final ImageFrame imageFrame = App.getImageFrame();
    if (isMaximized(imageFrame)) {
      final Rectangle bounds = getNextGraphicsDevice(imageFrame)
          .getDefaultConfiguration().getBounds();
      setLocation(bounds.x, bounds.y);
      maximize(this);      
    } else {
      moveToImageFrameMonitor(this);
    }
  }
  
  public void init() {
    final Machine machine = App.getMachine();
    if (machine != null) {
      ((MainCPU)machine.getCPU()).setScreenRenderer(imagePane);
    }
  }
  
  private void copyOtherImagePaneFields() {
    final ImagePane other = App.getImageFrame().getImagePane();
    imagePane.setCursorType(other.getCursorType());
    imagePane.setCursorVisible(other.isCursorVisible());
    imagePane.setFrameColor(other.getFrameColor());
    imagePane.setHideFullscreenMouseCursor(other.isHideFullscreenMouseCursor());
    imagePane.setHideInactiveMouseCursor(other.isHideInactiveMouseCursor());
    imagePane.setPaused(other.isPaused());
    imagePane.setRewinding(other.isRewinding());
    imagePane.setShowFPS(other.isShowFPS());
    imagePane.setShowStatusMessages(other.isShowStatusMessages());
    imagePane.setSmoothScaling(other.isSmoothScaling());    
    imagePane.setUseTvAspectRatio(other.isUseTvAspectRatio());
    imagePane.setTVSystem(other.getTVSystem());
    imagePane.setScreenScale(other.getScreenScale());    
    imagePane.setVideoFilterDescriptor(other.getVideoFilterDescriptor());
    imagePane.updateScreenBorders(); // sets the preferred size
  }
  
  public ImagePane getImagePane() {
    return imagePane;
  }  
  
  public void destroy() {
    final Machine machine = App.getMachine();
    if (machine != null && machine.isVsDualSystem()) {
      ((MainCPU)machine.getCPU()).clearScreenRenderer();
    }
    imagePane.destroy();
    DualAPU.setMainUpdateEnabled(true);
    dispose();
  }

  private void closeFrame() {
    App.destroySubMonitorFrame();
  } 
  
  public void enterFullscreenMode() {
    if (imagePane.getBufferStrategy() == null) {
      wasMaximized = isMaximized(this);
      final ImageFrame imageFrame = App.getImageFrame();
      if (sharesGraphicsDevice(imageFrame, this)) {
        moveToGraphicsDevice(this, getNextGraphicsDevice(imageFrame));
      }      
      final GraphicsDevice device = getGraphicsConfiguration().getDevice();
      dispose();
      requestVsync(this, false);
      setUndecorated(true);           
      setIgnoreRepaint(true);      
      device.setFullScreenWindow(this);
      createBufferStrategy(3);      
      imagePane.setBufferStrategy(getBufferStrategy());
      EventQueue.invokeLater(() -> setVisible(true));
      EventQueue.invokeLater(imagePane::redraw);
    }
  }
  
  public void exitFullscreenMode() {
    if (imagePane.getBufferStrategy() != null) {
      imagePane.getBufferStrategy().dispose();
      imagePane.setBufferStrategy(null);
      dispose();
      setUndecorated(false);
      setIgnoreRepaint(false);
      if (wasMaximized) {
        maximize(this);
      }
      requestVsync(this, true);
      EventQueue.invokeLater(() -> setVisible(true));  
      EventQueue.invokeLater(imagePane::redraw);
    }    
  }    

  public void setScreenScale(final int scale) {
    exitFullscreenMode();
    final Rectangle area = getScreenWorkingArea(this);
    if ((scale << 8) > area.width || 240 * scale > area.height) {
      maximize(this);
    } else {
      normalize(this);
      imagePane.setScreenScale(scale);
      maxipack(this);      
    }
  } 
  
  public void setUseTvAspectRatio(final boolean useTvAspectRatio) {
    if (imagePane.isUseTvAspectRatio() != useTvAspectRatio) {
      imagePane.setUseTvAspectRatio(useTvAspectRatio);
      maxipack(this);
    }
  }  

  /**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
    setTitle("Sub Monitor");
    setMinimumSize(null);
    addWindowFocusListener(new java.awt.event.WindowFocusListener() {
      public void windowGainedFocus(java.awt.event.WindowEvent evt) {
        formWindowGainedFocus(evt);
      }
      public void windowLostFocus(java.awt.event.WindowEvent evt) {
      }
    });
    addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent evt) {
        formWindowClosing(evt);
      }
      public void windowOpened(java.awt.event.WindowEvent evt) {
        formWindowOpened(evt);
      }
    });

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGap(0, 400, Short.MAX_VALUE)
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGap(0, 300, Short.MAX_VALUE)
    );
  }// </editor-fold>//GEN-END:initComponents

  private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
    closeFrame();
  }//GEN-LAST:event_formWindowClosing

  private void formWindowOpened(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowOpened
    requestVsync(this, true);
  }//GEN-LAST:event_formWindowOpened

  private void formWindowGainedFocus(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowGainedFocus
    DualAPU.setMainUpdateEnabled(false);
  }//GEN-LAST:event_formWindowGainedFocus

  // Variables declaration - do not modify//GEN-BEGIN:variables
  // End of variables declaration//GEN-END:variables
}
