package nintaco.gui.asmdasm;

import java.util.*;
import nintaco.*;
import nintaco.assembler.*;
import nintaco.disassembler.*;
import static nintaco.util.GuiUtil.*;
import static nintaco.util.StringUtil.*;

public class AsmDasmFrame extends javax.swing.JFrame {

  public AsmDasmFrame() {
    initComponents();
    makeMonospaced(assembleTextArea);
    makeMonospaced(disassembleTextArea);
    scaleFonts(this);
    setTextAreaSize(assembleTextArea, 40, 40);
    setTextAreaSize(disassembleTextArea, 40, 40);
    pack();
    moveToImageFrameMonitor(this);    
  }
  
  public void destroy() {
    dispose();
  }
  
  private void closeFrame() {    
    App.destroyAsmDasmFrame();
  }
  
  public void setMachineCode(final String machineCode) {
    disassembleTextArea.setText(machineCode);
    disassembleTextArea.setCaretPosition(0);
  }
  
  public void setMachineCode(final int[] machineCode) {
    final StringBuilder sb = new StringBuilder();
    for(int code : machineCode) {
      if (sb.length() > 0) {
        sb.append(' ');
      }
      sb.append(String.format("%02X", code));
    }
    setMachineCode(sb.toString());
  }
  
  public void assemble() {
    try {
      final int[] bytes = Assembler.assemble(assembleTextArea.getText());
      final StringBuilder sb = new StringBuilder();
      for(int b : bytes) {
        if (sb.length() > 0) {
          sb.append(' ');
        } 
        sb.append(String.format("%02X", b));
      }
      disassembleTextArea.setText(sb.toString());
    } catch(final MessageException e) {
      displayError(this, e.getMessage());
    }
    disassembleTextArea.setCaretPosition(0);
  }
  
  public void disassemble() {
    final String text = disassembleTextArea.getText().replaceAll("\\s+", "");
    final int[] bytes = new int[text.length() >> 1];
    for(int i = 0; i < bytes.length; i++) {
      final int index = i << 1;
      boolean error = false;
      if (!(isHexDigit(text.charAt(index)) 
          && isHexDigit(text.charAt(index + 1)))) {
        error = true;
      } else {
        try {        
          bytes[i] = Integer.parseInt(text.substring(index, index + 2), 16);
        } catch(final Throwable t) {
          error = true;
        }
      }
      if (error) {
        displayError(this, "Invalid hex value: %s", 
            text.substring(index, index + 2));
        return;
      }
    }
    final List<Instruction> instructions = Disassembler.disassemble(bytes, 
        false);
    final StringBuilder sb = new StringBuilder();
    for(final Instruction instruction : instructions) {
      if (sb.length() > 0) {
        sb.append('\n');
      }
      sb.append(instruction);
    }
    assembleTextArea.setText(sb.toString());
    assembleTextArea.setCaretPosition(0);
  }

  /**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    assemblePanel = new javax.swing.JPanel();
    assembleLabel = new javax.swing.JLabel();
    assembleScrollPane = new javax.swing.JScrollPane();
    assembleTextArea = new javax.swing.JTextArea();
    disassemblePanel = new javax.swing.JPanel();
    disassembleLabel = new javax.swing.JLabel();
    disassembleScrollPane = new javax.swing.JScrollPane();
    disassembleTextArea = new javax.swing.JTextArea();
    assembleButton = new javax.swing.JButton();
    disassembleButton = new javax.swing.JButton();

    setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
    setTitle("Assembler-Disassembler");
    setPreferredSize(null);
    addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent evt) {
        formWindowClosing(evt);
      }
    });

    assemblePanel.setMaximumSize(null);
    assemblePanel.setPreferredSize(null);

    assembleLabel.setText("Assembly code");
    assembleLabel.setMaximumSize(null);
    assembleLabel.setMinimumSize(null);
    assembleLabel.setPreferredSize(null);

    assembleScrollPane.setMaximumSize(null);
    assembleScrollPane.setMinimumSize(null);
    assembleScrollPane.setPreferredSize(null);

    assembleTextArea.setMaximumSize(null);
    assembleTextArea.setMinimumSize(null);
    assembleTextArea.setPreferredSize(null);
    assembleScrollPane.setViewportView(assembleTextArea);

    javax.swing.GroupLayout assemblePanelLayout = new javax.swing.GroupLayout(assemblePanel);
    assemblePanel.setLayout(assemblePanelLayout);
    assemblePanelLayout.setHorizontalGroup(
      assemblePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addComponent(assembleScrollPane, javax.swing.GroupLayout.Alignment.CENTER, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
      .addGroup(assemblePanelLayout.createSequentialGroup()
        .addComponent(assembleLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
    );
    assemblePanelLayout.setVerticalGroup(
      assemblePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(assemblePanelLayout.createSequentialGroup()
        .addGap(0, 0, 0)
        .addComponent(assembleLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(assembleScrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        .addGap(0, 0, 0))
    );

    disassemblePanel.setMaximumSize(null);
    disassemblePanel.setPreferredSize(null);

    disassembleLabel.setText("Machine code");
    disassembleLabel.setMaximumSize(null);
    disassembleLabel.setMinimumSize(null);
    disassembleLabel.setPreferredSize(null);

    disassembleScrollPane.setMaximumSize(null);
    disassembleScrollPane.setMinimumSize(null);
    disassembleScrollPane.setPreferredSize(null);

    disassembleTextArea.setWrapStyleWord(true);
    disassembleTextArea.setMaximumSize(null);
    disassembleTextArea.setPreferredSize(null);
    disassembleScrollPane.setViewportView(disassembleTextArea);

    javax.swing.GroupLayout disassemblePanelLayout = new javax.swing.GroupLayout(disassemblePanel);
    disassemblePanel.setLayout(disassemblePanelLayout);
    disassemblePanelLayout.setHorizontalGroup(
      disassemblePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addComponent(disassembleScrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
      .addGroup(disassemblePanelLayout.createSequentialGroup()
        .addComponent(disassembleLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
    );
    disassemblePanelLayout.setVerticalGroup(
      disassemblePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(disassemblePanelLayout.createSequentialGroup()
        .addGap(0, 0, 0)
        .addComponent(disassembleLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(disassembleScrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        .addGap(0, 0, 0))
    );

    assembleButton.setText("Assemble >");
    assembleButton.setMaximumSize(null);
    assembleButton.setMinimumSize(null);
    assembleButton.setPreferredSize(null);
    assembleButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        assembleButtonActionPerformed(evt);
      }
    });

    disassembleButton.setText("< Disassemble");
    disassembleButton.setMaximumSize(null);
    disassembleButton.setMinimumSize(null);
    disassembleButton.setPreferredSize(null);
    disassembleButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        disassembleButtonActionPerformed(evt);
      }
    });

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
          .addComponent(assembleButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(assemblePanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
          .addComponent(disassembleButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(disassemblePanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        .addContainerGap())
    );

    layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {assembleButton, disassembleButton});

    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(disassemblePanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
          .addComponent(assemblePanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(disassembleButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
            .addComponent(assembleButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
            .addContainerGap())))
    );
  }// </editor-fold>//GEN-END:initComponents

  private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
    closeFrame();
  }//GEN-LAST:event_formWindowClosing

  private void assembleButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_assembleButtonActionPerformed
    assemble();
  }//GEN-LAST:event_assembleButtonActionPerformed

  private void disassembleButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_disassembleButtonActionPerformed
    disassemble();
  }//GEN-LAST:event_disassembleButtonActionPerformed

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JButton assembleButton;
  private javax.swing.JLabel assembleLabel;
  private javax.swing.JPanel assemblePanel;
  private javax.swing.JScrollPane assembleScrollPane;
  private javax.swing.JTextArea assembleTextArea;
  private javax.swing.JButton disassembleButton;
  private javax.swing.JLabel disassembleLabel;
  private javax.swing.JPanel disassemblePanel;
  private javax.swing.JScrollPane disassembleScrollPane;
  private javax.swing.JTextArea disassembleTextArea;
  // End of variables declaration//GEN-END:variables
}
