package nintaco.gui.archive;

import java.awt.*;
import javax.swing.*;
import nintaco.preferences.*;
import static nintaco.util.GuiUtil.*;

public class ArchiveOptionsDialog extends javax.swing.JDialog {

  public ArchiveOptionsDialog(final Window parent) {
    super(parent);
    setModal(true);
    initComponents();
    loadFields();
    scaleFonts(this);
    pack();
    setLocationRelativeTo(parent);
  }
  
  private void closeDialog() {
    dispose();
  }
  
  private void loadFields() {
    final ArchivePrefs prefs = AppPrefs.getInstance().getArchivePrefs();
    regionComboBox.setSelectedItem(prefs.getArchiveEntryRegion());
    defaultFileCheckBox.setSelected(prefs.isOpenDefaultArchiveEntry());
  }
  
  private void saveFields() {
    final ArchivePrefs prefs = AppPrefs.getInstance().getArchivePrefs();
    prefs.setArchiveEntryRegion((EntryRegion)regionComboBox.getSelectedItem());
    prefs.setOpenDefaultArchiveEntry(defaultFileCheckBox.isSelected());
    AppPrefs.save();
  }  

  /**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    regionLabel = new javax.swing.JLabel();
    regionComboBox = new JComboBox(EntryRegion.values());
    defaultFileCheckBox = new javax.swing.JCheckBox();
    cancelButton = new javax.swing.JButton();
    okButton = new javax.swing.JButton();

    setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
    setTitle("Archive Options");
    addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent evt) {
        formWindowClosing(evt);
      }
    });

    regionLabel.setText("Preferred region:");

    regionComboBox.setFocusable(false);

    defaultFileCheckBox.setText("Automatically open the default file");
    defaultFileCheckBox.setFocusPainted(false);

    cancelButton.setText(" Cancel ");
    cancelButton.setFocusPainted(false);
    cancelButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        cancelButtonActionPerformed(evt);
      }
    });

    okButton.setMnemonic('O');
    okButton.setText("OK");
    okButton.setFocusPainted(false);
    okButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        okButtonActionPerformed(evt);
      }
    });

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addGap(15, 15, 15)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(defaultFileCheckBox)
          .addGroup(layout.createSequentialGroup()
            .addComponent(regionLabel)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(regionComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
        .addContainerGap(15, Short.MAX_VALUE))
      .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        .addComponent(okButton)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(cancelButton)
        .addContainerGap())
    );

    layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {cancelButton, okButton});

    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addGap(15, 15, 15)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
          .addComponent(regionLabel)
          .addComponent(regionComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
        .addComponent(defaultFileCheckBox)
        .addGap(18, 18, Short.MAX_VALUE)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(cancelButton)
          .addComponent(okButton))
        .addGap(15, 15, 15))
    );
  }// </editor-fold>//GEN-END:initComponents

  private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
    saveFields();
    closeDialog();
  }//GEN-LAST:event_okButtonActionPerformed

  private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
    closeDialog();
  }//GEN-LAST:event_cancelButtonActionPerformed

  private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
    closeDialog();
  }//GEN-LAST:event_formWindowClosing

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JButton cancelButton;
  private javax.swing.JCheckBox defaultFileCheckBox;
  private javax.swing.JButton okButton;
  private javax.swing.JComboBox<EntryRegion> regionComboBox;
  private javax.swing.JLabel regionLabel;
  // End of variables declaration//GEN-END:variables
}
