package nintaco.gui;

import java.awt.*;
import javax.swing.*;
import static nintaco.util.GuiUtil.*;

public class YesNoDialog extends javax.swing.JDialog {

  private boolean yes;
  
  public YesNoDialog(final Window parent, final String message, 
      final String title) {
    super(parent);
    setModal(true);    
    initComponents();
    getRootPane().setDefaultButton(yesButton);    
    scaleFonts(this);
    setQuestion(message, title);    
  }
  
  public final void setQuestion(String message, final String title) {
    if (!message.toLowerCase().trim().startsWith("<html>")) {
      message = "<html>" + message + "</html>";
    }
    setTitle(title);
    questionLabel.setText(message);
    questionLabel.setIcon(UIManager.getIcon("OptionPane.questionIcon"));
    pack();
    setLocationRelativeTo(getParent());
  } 
  
  public boolean isNo() {
    return !yes;
  }
  
  public boolean isYes() {
    return yes;
  }
  
  private void closeDialog() {
    dispose();
  }

  /**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    questionLabel = new javax.swing.JLabel();
    noButton = new javax.swing.JButton();
    yesButton = new javax.swing.JButton();

    setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
    setPreferredSize(null);
    addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent evt) {
        formWindowClosing(evt);
      }
    });

    questionLabel.setText(" ");
    questionLabel.setIconTextGap(16);

    noButton.setMnemonic('N');
    noButton.setText("No");
    noButton.setFocusPainted(false);
    noButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        noButtonActionPerformed(evt);
      }
    });

    yesButton.setMnemonic('Y');
    yesButton.setText("   Yes   ");
    yesButton.setFocusPainted(false);
    yesButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        yesButtonActionPerformed(evt);
      }
    });

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
        .addGap(15, 15, 15)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
          .addComponent(questionLabel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
          .addGroup(layout.createSequentialGroup()
            .addGap(0, 90, Short.MAX_VALUE)
            .addComponent(yesButton)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(noButton)))
        .addGap(15, 15, 15))
    );

    layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {noButton, yesButton});

    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addGap(15, 15, 15)
        .addComponent(questionLabel)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 16, Short.MAX_VALUE)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(noButton)
          .addComponent(yesButton))
        .addGap(15, 15, 15))
    );
  }// </editor-fold>//GEN-END:initComponents

  private void yesButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_yesButtonActionPerformed
    yes = true;
    closeDialog();
  }//GEN-LAST:event_yesButtonActionPerformed

  private void noButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_noButtonActionPerformed
    closeDialog();
  }//GEN-LAST:event_noButtonActionPerformed

  private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
    closeDialog();
  }//GEN-LAST:event_formWindowClosing

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JButton noButton;
  private javax.swing.JLabel questionLabel;
  private javax.swing.JButton yesButton;
  // End of variables declaration//GEN-END:variables
}
