package nintaco.gui;

import javax.swing.*;

public class WideButtonsDialog extends javax.swing.JDialog {

  private JButton[] buttons;
  
  private int buttonIndex = -1;
  
  public WideButtonsDialog(final java.awt.Window parent, final String question, 
      final String title, final String... buttonTexts) {
    super(parent);
    setModal(true);
    initComponents();
    setQuestion(question);
    setTitle(title);
    setButtons(buttonTexts);
  }
  
  public int getButtonIndex() {
    return buttonIndex;
  }
  
  private void closeDialog() {
    dispose();
  }
  
  private void setButtonIndex(final int buttonIndex) {
    this.buttonIndex = buttonIndex;
    closeDialog();
  }
  
  public final void setQuestion(String question) {
    if (!question.toLowerCase().trim().startsWith("<html>")) {
      question = "<html>" + question + "</html>";
    }
    questionLabel.setText(question);
    questionLabel.setIcon(UIManager.getIcon("OptionPane.questionIcon"));
    pack();
    setLocationRelativeTo(getParent());
  }
  
  public final void setButtons(final String... buttonTexts) {
    
    buttons = new JButton[buttonTexts.length];
    
    for(int i = buttons.length - 1; i >= 0; i--) {
      final JButton button = buttons[i] = new JButton(buttonTexts[i]);
      button.setMaximumSize(null);
      button.setMinimumSize(null);
      button.setPreferredSize(null);
      button.setFocusPainted(false);
      
      final int index = i;
      button.addActionListener(e -> setButtonIndex(index));
    }
    
    getContentPane().removeAll();
    getContentPane().setLayout(null);
    
    final GroupLayout layout = new GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    
    GroupLayout.ParallelGroup horizontalGroup = layout.createParallelGroup(
        GroupLayout.Alignment.LEADING).addComponent(questionLabel, 
            GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, 
                Short.MAX_VALUE);
    GroupLayout.SequentialGroup sequentialGroup = layout.createSequentialGroup()
        .addGap(15, 15, 15)
        .addComponent(questionLabel)
        .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
    for(final JButton button : buttons) {
      horizontalGroup = horizontalGroup.addComponent(button, 
          GroupLayout.DEFAULT_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE);
      sequentialGroup = sequentialGroup.addComponent(button, 
          GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, 
              GroupLayout.PREFERRED_SIZE)
                  .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
    }
    sequentialGroup = sequentialGroup.addGap(15, 15, 15);
    
    layout.setHorizontalGroup(
      layout.createParallelGroup(GroupLayout.Alignment.LEADING)
        .addGroup(layout.createSequentialGroup()
          .addGap(15, 15, 15)
          .addGroup(horizontalGroup)
          .addGap(15, 15, 15))
    );
    
    layout.setVerticalGroup(layout.createParallelGroup(
        GroupLayout.Alignment.LEADING).addGroup(sequentialGroup));
    
    pack();
    setLocationRelativeTo(getParent());
  }

  /**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    questionLabel = new javax.swing.JLabel();

    setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
    setPreferredSize(null);
    addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent evt) {
        formWindowClosing(evt);
      }
    });

    questionLabel.setText(" ");
    questionLabel.setIconTextGap(16);
    questionLabel.setPreferredSize(null);

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addGap(15, 15, 15)
        .addComponent(questionLabel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        .addGap(15, 15, 15))
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addGap(15, 15, 15)
        .addComponent(questionLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addGap(15, 15, 15))
    );
  }// </editor-fold>//GEN-END:initComponents

  private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
    closeDialog();
  }//GEN-LAST:event_formWindowClosing

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JLabel questionLabel;
  // End of variables declaration//GEN-END:variables
}
