package nintaco.gui;

import java.awt.*;
import static java.lang.Math.*;
import static nintaco.util.GuiUtil.*;
import static nintaco.util.StringUtil.*;

public class TextDialog extends javax.swing.JDialog {

  public TextDialog(final Window parent, final String text, 
      final String title) {
    super(parent);
    setModal(true);
    initComponents();
    setTitle(title);
    getRootPane().setDefaultButton(okButton);
    textArea.setFont(new Font(Font.MONOSPACED, Font.PLAIN, 
        textArea.getFont().getSize()));
    scaleFonts(this);
    final IntPoint dimensions = getTextDimensions(text);
    textArea.setColumns(min(dimensions.x, 160) + 1);
    textArea.setRows(min(dimensions.y, 32));
    textArea.setText(text);
    textArea.setCaretPosition(0);
    pack();
    setLocationRelativeTo(parent);
  }
  
  private void closeDialog() {
    dispose();
  }

  /**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    okButton = new javax.swing.JButton();
    scrollPane = new javax.swing.JScrollPane();
    textArea = new javax.swing.JTextArea();

    setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
    setModal(true);
    setPreferredSize(null);
    addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent evt) {
        formWindowClosing(evt);
      }
    });

    okButton.setFocusPainted(false);
    okButton.setLabel("   OK   ");
    okButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        okButtonActionPerformed(evt);
      }
    });

    scrollPane.setPreferredSize(null);

    textArea.setEditable(false);
    textArea.setColumns(60);
    textArea.setRows(32);
    textArea.setPreferredSize(null);
    scrollPane.setViewportView(textArea);

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(scrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
          .addGroup(layout.createSequentialGroup()
            .addGap(0, 0, Short.MAX_VALUE)
            .addComponent(okButton)))
        .addContainerGap())
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
        .addContainerGap()
        .addComponent(scrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(okButton)
        .addContainerGap())
    );
  }// </editor-fold>//GEN-END:initComponents

  private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
    closeDialog();
  }//GEN-LAST:event_okButtonActionPerformed

  private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
    closeDialog();
  }//GEN-LAST:event_formWindowClosing

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JButton okButton;
  private javax.swing.JScrollPane scrollPane;
  private javax.swing.JTextArea textArea;
  // End of variables declaration//GEN-END:variables
}
