package nintaco.gui;

import java.awt.*;
import javax.swing.*;

public class RadioSelectionDialog extends javax.swing.JDialog {

  private final ButtonGroup buttonGroup = new ButtonGroup();
  
  private JRadioButton[] radioButtons;
  private boolean ok;
  private int selectedIndex = -1;
  
  public RadioSelectionDialog(Window parent, String message, 
      String title, int defaultOption, String... options) {
    super(parent);
    setModal(true);
    initComponents();
    initRadioButtons(options, defaultOption);
    setPrompt(message, title);
  }
  
  public boolean isOk() {
    return ok;
  }  

  public int getSelectedIndex() {
    return selectedIndex;
  }

  @Override
  public void setVisible(boolean visible) {    
    pack();
    setLocationRelativeTo(getParent());
    super.setVisible(visible);
  }
  
  private void initRadioButtons(final String[] options, 
      final int defaultOption) {
    
    GroupLayout radioButtonPanelLayout = new GroupLayout(radioButtonPanel);
    radioButtonPanel.setLayout(radioButtonPanelLayout);
    GroupLayout.ParallelGroup parallelGroup = radioButtonPanelLayout
        .createParallelGroup(GroupLayout.Alignment.LEADING);
    GroupLayout.SequentialGroup sequentialGroup = radioButtonPanelLayout
        .createSequentialGroup();
    
    radioButtons = new JRadioButton[options.length];
    for(int i = 0; i < options.length; i++) {
      radioButtons[i] = new JRadioButton(options[i]);
      buttonGroup.add(radioButtons[i]);
      parallelGroup.addComponent(radioButtons[i]);
      if (i > 0) {
        sequentialGroup.addPreferredGap(
            LayoutStyle.ComponentPlacement.UNRELATED);
      }
      sequentialGroup.addComponent(radioButtons[i]);
    }
    sequentialGroup.addGap(0, 0, Short.MAX_VALUE);
    
    radioButtonPanelLayout.setHorizontalGroup(radioButtonPanelLayout
        .createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGroup(radioButtonPanelLayout.createSequentialGroup()
                .addGroup(parallelGroup).addGap(0, 0, Short.MAX_VALUE)));
    radioButtonPanelLayout.setVerticalGroup(radioButtonPanelLayout
        .createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGroup(sequentialGroup));
    
    radioButtons[defaultOption].setSelected(true);
  }
  
  public final void setPrompt(String message, String title) {
    if (!message.toLowerCase().trim().startsWith("<html>")) {
      message = "<html>" + message + "</html>";
    }
    setTitle(title);
    promptLabel.setText(message);
    iconLabel.setIcon(UIManager.getIcon("OptionPane.questionIcon"));           
  }
  
  public void setOkButtonMnemonic(char mnemonic) {
    okButton.setMnemonic(mnemonic);
  }
  
  public void setOkButtonText(String text) {
    okButton.setText(text);
  }
  
  public void setCancelButtonMnemonic(char mnemonic) {
    cancelButton.setMnemonic(mnemonic);
  }
  
  public void setCancelButtonText(String text) {
    cancelButton.setText(text);
  }  
  
  private void closeDialog() {
    dispose();
  }

  /**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    iconPanel = new javax.swing.JPanel();
    iconLabel = new javax.swing.JLabel();
    promptPanel = new javax.swing.JPanel();
    promptLabel = new javax.swing.JLabel();
    radioButtonPanel = new javax.swing.JPanel();
    okButton = new javax.swing.JButton();
    cancelButton = new javax.swing.JButton();

    setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
    setPreferredSize(null);
    addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent evt) {
        formWindowClosing(evt);
      }
    });

    iconLabel.setText(" ");
    iconLabel.setPreferredSize(null);

    javax.swing.GroupLayout iconPanelLayout = new javax.swing.GroupLayout(iconPanel);
    iconPanel.setLayout(iconPanelLayout);
    iconPanelLayout.setHorizontalGroup(
      iconPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addComponent(iconLabel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
    );
    iconPanelLayout.setVerticalGroup(
      iconPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(iconPanelLayout.createSequentialGroup()
        .addComponent(iconLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addGap(0, 0, Short.MAX_VALUE))
    );

    promptLabel.setText(" ");
    promptLabel.setPreferredSize(null);

    javax.swing.GroupLayout radioButtonPanelLayout = new javax.swing.GroupLayout(radioButtonPanel);
    radioButtonPanel.setLayout(radioButtonPanelLayout);
    radioButtonPanelLayout.setHorizontalGroup(
      radioButtonPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGap(0, 0, Short.MAX_VALUE)
    );
    radioButtonPanelLayout.setVerticalGroup(
      radioButtonPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGap(0, 127, Short.MAX_VALUE)
    );

    javax.swing.GroupLayout promptPanelLayout = new javax.swing.GroupLayout(promptPanel);
    promptPanel.setLayout(promptPanelLayout);
    promptPanelLayout.setHorizontalGroup(
      promptPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addComponent(promptLabel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
      .addComponent(radioButtonPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
    );
    promptPanelLayout.setVerticalGroup(
      promptPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(promptPanelLayout.createSequentialGroup()
        .addComponent(promptLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addGap(15, 15, 15)
        .addComponent(radioButtonPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
    );

    okButton.setMnemonic('O');
    okButton.setText("OK");
    okButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        okButtonActionPerformed(evt);
      }
    });

    cancelButton.setMnemonic('C');
    cancelButton.setText("   Cancel   ");
    cancelButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        cancelButtonActionPerformed(evt);
      }
    });

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addGap(15, 15, 15)
        .addComponent(iconPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(promptPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
          .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
            .addGap(0, 0, Short.MAX_VALUE)
            .addComponent(okButton)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(cancelButton)))
        .addGap(15, 15, 15))
    );

    layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {cancelButton, okButton});

    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
        .addGap(15, 15, 15)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
          .addGroup(layout.createSequentialGroup()
            .addComponent(promptPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addGap(15, 15, 15)
            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
              .addComponent(cancelButton)
              .addComponent(okButton)))
          .addComponent(iconPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        .addGap(15, 15, 15))
    );
  }// </editor-fold>//GEN-END:initComponents

  private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
    closeDialog();
  }//GEN-LAST:event_formWindowClosing

  private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
    ok = true;
    for(int i = radioButtons.length - 1; i >= 0; i--) {
      if (radioButtons[i].isSelected()) {
        selectedIndex = i;
        break;
      }
    }
    closeDialog();
  }//GEN-LAST:event_okButtonActionPerformed

  private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
    closeDialog();
  }//GEN-LAST:event_cancelButtonActionPerformed

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JButton cancelButton;
  private javax.swing.JLabel iconLabel;
  private javax.swing.JPanel iconPanel;
  private javax.swing.JButton okButton;
  private javax.swing.JLabel promptLabel;
  private javax.swing.JPanel promptPanel;
  private javax.swing.JPanel radioButtonPanel;
  // End of variables declaration//GEN-END:variables
}
