package nintaco.gui;

import java.awt.*;
import static nintaco.util.GuiUtil.*;

public class ProgressDialog extends javax.swing.JDialog {
  
  private final Runnable cancelListener;

  public ProgressDialog(final Window parent, 
      final Runnable cancelListener) {
    super(parent);
    setModal(true);
    this.cancelListener = cancelListener;
    initComponents();
    scaleFonts(this);
    pack();
    setLocationRelativeTo(parent);
  }
  
  public void setMessage(final String message) {
    if (EventQueue.isDispatchThread()) {
      messageLabel.setText(message);
    } else {
      EventQueue.invokeLater(() -> setMessage(message));
    }
  }
  
  public void setMinimum(final int minimum) {
    if (EventQueue.isDispatchThread()) {
      progressBar.setMinimum(minimum);
    } else {
      EventQueue.invokeLater(() -> setMinimum(minimum));
    }
  }
  
  public void setMaximum(final int maximum) {
    if (EventQueue.isDispatchThread()) {
      progressBar.setMaximum(maximum);
    } else {
      EventQueue.invokeLater(() -> setMaximum(maximum));
    }
  }  
  
  public void setValue(final int value) {
    if (EventQueue.isDispatchThread()) {
      progressBar.setValue(value);
    } else {
      EventQueue.invokeLater(() -> setValue(value));
    }
  }
  
  @Override
  public void dispose() {
    if (EventQueue.isDispatchThread()) {
      super.dispose();
    } else {
      EventQueue.invokeLater(this::dispose);
    }
  }
  
  private void cancel() {
    if (cancelListener != null) {
      cancelListener.run();
    }
  }

  /**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    messageLabel = new javax.swing.JLabel();
    progressBar = new javax.swing.JProgressBar();
    cancelButton = new javax.swing.JButton();

    setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
    addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent evt) {
        formWindowClosing(evt);
      }
    });

    messageLabel.setText("Please wait...");

    cancelButton.setMnemonic('C');
    cancelButton.setText(" Cancel ");
    cancelButton.setFocusPainted(false);
    cancelButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        cancelButtonActionPerformed(evt);
      }
    });

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addGroup(layout.createSequentialGroup()
            .addComponent(messageLabel)
            .addGap(0, 0, Short.MAX_VALUE))
          .addComponent(progressBar, javax.swing.GroupLayout.DEFAULT_SIZE, 513, Short.MAX_VALUE)
          .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
            .addGap(0, 0, Short.MAX_VALUE)
            .addComponent(cancelButton)))
        .addContainerGap())
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addComponent(messageLabel)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(progressBar, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        .addComponent(cancelButton)
        .addContainerGap())
    );
  }// </editor-fold>//GEN-END:initComponents

  private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
    cancel();
  }//GEN-LAST:event_cancelButtonActionPerformed

  private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
    cancel();
  }//GEN-LAST:event_formWindowClosing

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JButton cancelButton;
  private javax.swing.JLabel messageLabel;
  private javax.swing.JProgressBar progressBar;
  // End of variables declaration//GEN-END:variables
}
