package nintaco.gui;

import java.awt.*;
import static nintaco.util.GuiUtil.*;
import static nintaco.util.StringUtil.*;
import static nintaco.util.ThreadUtil.*;

public class PleaseWaitDialog extends javax.swing.JDialog {
  
  private static final int DISPLAY_MILLIS = 400;
  
  private volatile boolean disposed;
  
  public PleaseWaitDialog(final Window parent) {
    super(parent);
    initComponents();
    progressBar.setIndeterminate(true);
    scaleFonts(this);  
    pack();
    setLocationRelativeTo(parent);
  }
  
  public final void setMessage(final String message) {
    if (isBlank(message)) {
      messageLabel.setText("Please wait...");
    } else {
      messageLabel.setText(message);
    }
  }
  
  // Blocks the event dispatch thread for up to DISPLAY_MILLIS
  public void showAfterDelay() {
    if (EventQueue.isDispatchThread()) {
      if (!disposed) {
        synchronized(this) {
          final long displayTime = System.currentTimeMillis() + DISPLAY_MILLIS;
          while(!disposed) {
            final long timeout = displayTime - System.currentTimeMillis();
            if (timeout <= 0) {
              break;
            }
            threadWait(this, timeout);
          }
        }
        if (!disposed) {
          setVisible(true);
        }
      }
    } else {
      EventQueue.invokeLater(this::showAfterDelay);
    }
  }

  // This should be called from a worker thread, not the event dispatch thread.
  @Override
  public void dispose() {
    if (!disposed) {
      if (EventQueue.isDispatchThread()) {
        System.err.println("-- THIS SHOULD BE ON A WORKER THREAD --");
        Thread.dumpStack();
      }
      synchronized(this) {
        disposed = true;    
        notifyAll();
      }      
      EventQueue.invokeLater(super::dispose);
    }
  }

  /**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    messageLabel = new javax.swing.JLabel();
    progressBar = new javax.swing.JProgressBar();

    setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
    setTitle("Preparing Content");
    setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
    setModal(true);
    setPreferredSize(null);

    messageLabel.setText("Please wait...");
    messageLabel.setVerticalAlignment(javax.swing.SwingConstants.TOP);

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(messageLabel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
          .addComponent(progressBar, javax.swing.GroupLayout.DEFAULT_SIZE, 513, Short.MAX_VALUE))
        .addContainerGap())
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addComponent(messageLabel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(progressBar, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addContainerGap())
    );
  }// </editor-fold>//GEN-END:initComponents

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JLabel messageLabel;
  private javax.swing.JProgressBar progressBar;
  // End of variables declaration//GEN-END:variables
}
