package nintaco.gui;

import java.awt.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import nintaco.preferences.*;
import static nintaco.util.GuiUtil.*;

public class PasswordDialog extends javax.swing.JDialog {

  private boolean ok;
  private boolean rememberPassword;
  private char[] password;
  private boolean textRequired;
  private DocumentListener documentListener;
  
  public PasswordDialog(final Window parent, final String message, 
      final String title) {
    super(parent);
    setModal(true);
    initComponents();
    initDocumentListener();
    getRootPane().setDefaultButton(okButton);
    scaleFonts(this);
    setPrompt(message, title);
  }
  
  private void initDocumentListener() {
    documentListener = createDocumentListener(this::enableComponents);
    passwordField.getDocument().addDocumentListener(documentListener);
  }
  
  @Override
  public void setVisible(final boolean visible) {    
    pack();
    setLocationRelativeTo(getParent());
    super.setVisible(visible);
  } 
  
  public void setPassword(final int passwordLength) {
    final StringBuilder sb = new StringBuilder();
    for(int i = passwordLength - 1; i >= 0; i--) {
      sb.append('*');
    }
    setPassword(sb.toString());
  }  
  
  public void setPassword(final String password) {
    if (password == null) {
      return;
    }    
    passwordField.getDocument().removeDocumentListener(documentListener);
    passwordField.setText(password);
    passwordField.getDocument().addDocumentListener(documentListener);
    passwordField.selectAll();    
    enableComponents();
    passwordField.requestFocus();
  }
  
  public void setRememberPassword(final boolean rememberPassword) {
    passwordCheckBox.setSelected(rememberPassword);
  }
  
  private void enableComponents() {
    okButton.setEnabled(!textRequired 
        || passwordField.getPassword().length > 0);
  }
  
  public void setPasswordRequired() {
    textRequired = true;
    enableComponents();
  }
  
  public final void setPrompt(String message, String title) {
    if (!message.toLowerCase().trim().startsWith("<html>")) {
      message = "<html>" + message + "</html>";
    }
    setTitle(title);
    promptLabel.setText(message);
    iconLabel.setIcon(UIManager.getIcon("OptionPane.questionIcon"));
    passwordField.requestFocus();
  }
  
  public void setOkButtonMnemonic(final char mnemonic) {
    okButton.setMnemonic(mnemonic);
  }
  
  public void setOkButtonText(final String text) {
    okButton.setText(text);
  }
  
  public void setCancelButtonMnemonic(char mnemonic) {
    cancelButton.setMnemonic(mnemonic);
  }
  
  public void setCancelButtonText(String text) {
    cancelButton.setText(text);
  }  

  public char[] getPassword() {    
    return password;
  }

  public boolean isOk() {
    return ok;
  }

  public boolean isRememberPassword() {
    return rememberPassword;
  }
  
  private void closeDialog() {
    dispose();
  }  
  
  /**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    cancelButton = new javax.swing.JButton();
    okButton = new javax.swing.JButton();
    inputPanel = new javax.swing.JPanel();
    promptLabel = new javax.swing.JLabel();
    passwordField = new javax.swing.JPasswordField();
    passwordCheckBox = new javax.swing.JCheckBox();
    iconLabel = new javax.swing.JLabel();
    spacerPanel = new javax.swing.JPanel();

    setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
    setMaximumSize(null);
    setMinimumSize(null);
    setPreferredSize(null);
    addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent evt) {
        formWindowClosing(evt);
      }
    });

    cancelButton.setMnemonic('C');
    cancelButton.setLabel("   Cancel   ");
    cancelButton.setMaximumSize(null);
    cancelButton.setMinimumSize(null);
    cancelButton.setPreferredSize(null);
    cancelButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        cancelButtonActionPerformed(evt);
      }
    });

    okButton.setMnemonic('O');
    okButton.setText("OK");
    okButton.setMaximumSize(null);
    okButton.setMinimumSize(null);
    okButton.setPreferredSize(null);
    okButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        okButtonActionPerformed(evt);
      }
    });

    promptLabel.setText(" ");

    passwordField.setColumns(16);
    passwordField.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        passwordFieldActionPerformed(evt);
      }
    });

    passwordCheckBox.setText("Remember password");

    javax.swing.GroupLayout inputPanelLayout = new javax.swing.GroupLayout(inputPanel);
    inputPanel.setLayout(inputPanelLayout);
    inputPanelLayout.setHorizontalGroup(
      inputPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(inputPanelLayout.createSequentialGroup()
        .addGap(15, 15, 15)
        .addGroup(inputPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addGroup(inputPanelLayout.createSequentialGroup()
            .addComponent(passwordCheckBox)
            .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
          .addGroup(inputPanelLayout.createSequentialGroup()
            .addGroup(inputPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
              .addComponent(passwordField)
              .addComponent(promptLabel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
            .addGap(1, 1, 1))))
    );
    inputPanelLayout.setVerticalGroup(
      inputPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(inputPanelLayout.createSequentialGroup()
        .addGap(0, 0, 0)
        .addComponent(promptLabel)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(passwordField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
        .addComponent(passwordCheckBox)
        .addContainerGap())
    );

    iconLabel.setText(" ");

    spacerPanel.setMaximumSize(null);

    javax.swing.GroupLayout spacerPanelLayout = new javax.swing.GroupLayout(spacerPanel);
    spacerPanel.setLayout(spacerPanelLayout);
    spacerPanelLayout.setHorizontalGroup(
      spacerPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGap(0, 50, Short.MAX_VALUE)
    );
    spacerPanelLayout.setVerticalGroup(
      spacerPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGap(0, 0, Short.MAX_VALUE)
    );

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
        .addGap(15, 15, 15)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
          .addComponent(spacerPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(iconLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 50, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(inputPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
          .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
            .addGap(15, 15, 15)
            .addComponent(okButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(cancelButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
        .addGap(15, 15, 15))
    );

    layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {cancelButton, okButton});

    layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {iconLabel, spacerPanel});

    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addGap(15, 15, 15)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(iconLabel)
          .addComponent(inputPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addGap(18, 18, Short.MAX_VALUE)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addGroup(layout.createSequentialGroup()
            .addGap(0, 0, Short.MAX_VALUE)
            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
              .addComponent(cancelButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
              .addComponent(okButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
          .addComponent(spacerPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        .addGap(15, 15, 15))
    );
  }// </editor-fold>//GEN-END:initComponents

  private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
    closeDialog();
  }//GEN-LAST:event_formWindowClosing

  private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
    ok = true;
    password = passwordField.getPassword();    
    rememberPassword = passwordCheckBox.isSelected();    
    closeDialog();
  }//GEN-LAST:event_okButtonActionPerformed

  private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
    closeDialog();
  }//GEN-LAST:event_cancelButtonActionPerformed

  private void passwordFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_passwordFieldActionPerformed
    if (okButton.isEnabled()) {
      okButton.doClick();
    }
  }//GEN-LAST:event_passwordFieldActionPerformed

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JButton cancelButton;
  private javax.swing.JLabel iconLabel;
  private javax.swing.JPanel inputPanel;
  private javax.swing.JButton okButton;
  private javax.swing.JCheckBox passwordCheckBox;
  private javax.swing.JPasswordField passwordField;
  private javax.swing.JLabel promptLabel;
  private javax.swing.JPanel spacerPanel;
  // End of variables declaration//GEN-END:variables
}
