package nintaco.gui;

import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import static nintaco.util.GuiUtil.*;

public class InputDialog extends javax.swing.JDialog {

  @FunctionalInterface
  public static interface InputValidator {
    boolean validate(final String text);
  }
  
  private boolean ok;
  private String input;
  private boolean textRequired;
  private InputValidator inputValidator;
  private DocumentListener documentListener;  
  
  public InputDialog(Window parent, String message, String title) {
    super(parent);
    setModal(true);
    initComponents();
    initDocumentListener();
    getRootPane().setDefaultButton(okButton);
    scaleFonts(this);
    setPrompt(message, title);
  }
  
  private void initDocumentListener() {
    documentListener = createDocumentListener(this::enableComponents);
    inputTextField.getDocument().addDocumentListener(documentListener);
  }
  
  @Override
  public void setVisible(final boolean visible) {    
    pack();
    setLocationRelativeTo(getParent());
    super.setVisible(visible);
  }  

  public void setInputValidator(final InputValidator inputValidator) {
    this.inputValidator = inputValidator;
  }
  
  public void setMaxInputLength(final int maxLength) {
    limitTextFieldLength(inputTextField, maxLength);
    initDocumentListener();
  }
  
  public void setInput(String input) {
    if (input == null) {
      return;
    }
    inputTextField.getDocument().removeDocumentListener(documentListener);
    inputTextField.setText(input);
    inputTextField.getDocument().addDocumentListener(documentListener);
    inputTextField.selectAll();
    enableComponents();
    inputTextField.requestFocus();
  }
  
  private void enableComponents() {
    final String text = inputTextField.getText();
    boolean enabled = !(textRequired && text.isEmpty());
    if (enabled && inputValidator != null) {
      enabled = inputValidator.validate(text);
    }
    okButton.setEnabled(enabled);
  }
  
  public void setTextRequired() {
    textRequired = true;
    enableComponents();
  }
  
  public final void setPrompt(String message, String title) {
    if (!message.toLowerCase().trim().startsWith("<html>")) {
      message = "<html>" + message + "</html>";
    }
    setTitle(title);
    promptLabel.setText(message);
    iconLabel.setIcon(UIManager.getIcon("OptionPane.questionIcon"));
    inputTextField.requestFocus();
  }
  
  public void setOkButtonMnemonic(char mnemonic) {
    okButton.setMnemonic(mnemonic);
  }
  
  public void setOkButtonText(String text) {
    okButton.setText(text);
  }
  
  public void setCancelButtonMnemonic(char mnemonic) {
    cancelButton.setMnemonic(mnemonic);
  }
  
  public void setCancelButtonText(String text) {
    cancelButton.setText(text);
  }  

  public String getInput() {
    return input;
  }

  public boolean isOk() {
    return ok;
  }
  
  private void closeDialog() {
    dispose();
  }  
  
  /**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    cancelButton = new javax.swing.JButton();
    okButton = new javax.swing.JButton();
    inputPanel = new javax.swing.JPanel();
    inputTextField = new javax.swing.JTextField();
    promptLabel = new javax.swing.JLabel();
    iconLabel = new javax.swing.JLabel();
    spacerPanel = new javax.swing.JPanel();

    setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
    setMaximumSize(null);
    setMinimumSize(null);
    setPreferredSize(null);
    addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent evt) {
        formWindowClosing(evt);
      }
    });

    cancelButton.setMnemonic('C');
    cancelButton.setFocusPainted(false);
    cancelButton.setLabel("   Cancel   ");
    cancelButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        cancelButtonActionPerformed(evt);
      }
    });

    okButton.setMnemonic('O');
    okButton.setText("OK");
    okButton.setFocusPainted(false);
    okButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        okButtonActionPerformed(evt);
      }
    });

    inputTextField.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        inputTextFieldActionPerformed(evt);
      }
    });

    promptLabel.setText(" ");

    javax.swing.GroupLayout inputPanelLayout = new javax.swing.GroupLayout(inputPanel);
    inputPanel.setLayout(inputPanelLayout);
    inputPanelLayout.setHorizontalGroup(
      inputPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, inputPanelLayout.createSequentialGroup()
        .addGap(15, 15, 15)
        .addGroup(inputPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
          .addComponent(inputTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
          .addComponent(promptLabel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        .addGap(1, 1, 1))
    );
    inputPanelLayout.setVerticalGroup(
      inputPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(inputPanelLayout.createSequentialGroup()
        .addGap(0, 0, 0)
        .addComponent(promptLabel)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(inputTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addGap(15, 15, 15))
    );

    iconLabel.setText(" ");

    spacerPanel.setMaximumSize(null);

    javax.swing.GroupLayout spacerPanelLayout = new javax.swing.GroupLayout(spacerPanel);
    spacerPanel.setLayout(spacerPanelLayout);
    spacerPanelLayout.setHorizontalGroup(
      spacerPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGap(0, 50, Short.MAX_VALUE)
    );
    spacerPanelLayout.setVerticalGroup(
      spacerPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGap(0, 0, Short.MAX_VALUE)
    );

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
        .addGap(15, 15, 15)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
          .addComponent(spacerPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(iconLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 50, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(inputPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
          .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
            .addGap(15, 15, 15)
            .addComponent(okButton)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(cancelButton)))
        .addGap(15, 15, 15))
    );

    layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {cancelButton, okButton});

    layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {iconLabel, spacerPanel});

    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addGap(15, 15, 15)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(iconLabel)
          .addComponent(inputPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addGap(0, 0, Short.MAX_VALUE)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addGroup(layout.createSequentialGroup()
            .addGap(0, 0, Short.MAX_VALUE)
            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
              .addComponent(cancelButton)
              .addComponent(okButton)))
          .addComponent(spacerPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        .addGap(15, 15, 15))
    );
  }// </editor-fold>//GEN-END:initComponents

  private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
    closeDialog();
  }//GEN-LAST:event_formWindowClosing

  private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
    ok = true;
    input = inputTextField.getText();
    closeDialog();
  }//GEN-LAST:event_okButtonActionPerformed

  private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
    closeDialog();
  }//GEN-LAST:event_cancelButtonActionPerformed

  private void inputTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_inputTextFieldActionPerformed
    if (okButton.isEnabled()) {
      okButton.doClick();
    }
  }//GEN-LAST:event_inputTextFieldActionPerformed

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JButton cancelButton;
  private javax.swing.JLabel iconLabel;
  private javax.swing.JPanel inputPanel;
  private javax.swing.JTextField inputTextField;
  private javax.swing.JButton okButton;
  private javax.swing.JLabel promptLabel;
  private javax.swing.JPanel spacerPanel;
  // End of variables declaration//GEN-END:variables
}
