package nintaco.gui;

import java.awt.*;
import javax.swing.*;
import java.util.List;
import static nintaco.util.GuiUtil.*;

public class ComboBoxDialog extends javax.swing.JDialog {

  private boolean ok;
  private String input;
  private int inputIndex;
  
  public ComboBoxDialog(final Window parent, final String message, 
      final String title) {
    this(parent, message, title, null);
  }
  
  public ComboBoxDialog(final Window parent, final String message, 
      final String title, final List<String> items) {
    super(parent);
    setModal(true);
    initComponents();
    getRootPane().setDefaultButton(okButton);
    scaleFonts(this);
    setPrompt(message, title, items);
  }
  
  public final void setPrompt(final String message, final String title) {
    setPrompt(message, title, null);
  }
  
  public final void setPrompt(String message, final String title, 
      final List<String> items) {
    if (!message.toLowerCase().trim().startsWith("<html>")) {
      message = "<html>" + message + "</html>";
    }
    setTitle(title);
    promptLabel.setText(message);
    iconLabel.setIcon(UIManager.getIcon("OptionPane.questionIcon"));    
    if (items != null) {
      final DefaultComboBoxModel model = new DefaultComboBoxModel();
      for(final String item : items) {
        model.addElement(item);
      }
      inputComboBox.setModel(model);
      inputComboBox.setSelectedItem("");
    }
    inputComboBox.requestFocus();
    pack();
    setLocationRelativeTo(getParent());
  }
  
  public void setOkButtonText(final String text) {
    okButton.setText(text);
  }
  
  public void setOkButtonMnemonic(final char mnemonic) {
    okButton.setMnemonic(mnemonic);
  }  
  
  public void setCancelButtonText(final String text) {
    cancelButton.setText(text);
  }
  
  public void setCancelButtonMnemonic(final char mnemonic) {
    cancelButton.setMnemonic(mnemonic);
  }  

  public String getInput() {
    return input;
  }

  public int getInputIndex() {
    return inputIndex;
  }

  public boolean isOk() {
    return ok;
  }
  
  private void closeDialog() {
    dispose();
  }  
  
  /**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    cancelButton = new javax.swing.JButton();
    okButton = new javax.swing.JButton();
    inputPanel = new javax.swing.JPanel();
    promptLabel = new javax.swing.JLabel();
    inputComboBox = new javax.swing.JComboBox();
    iconLabel = new javax.swing.JLabel();
    spacerPanel = new javax.swing.JPanel();

    setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
    setPreferredSize(null);
    addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent evt) {
        formWindowClosing(evt);
      }
    });

    cancelButton.setMnemonic('C');
    cancelButton.setText("   Cancel   ");
    cancelButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        cancelButtonActionPerformed(evt);
      }
    });

    okButton.setMnemonic('O');
    okButton.setText("OK");
    okButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        okButtonActionPerformed(evt);
      }
    });

    promptLabel.setText(" ");

    inputComboBox.setFocusable(false);
    inputComboBox.setMaximumSize(null);
    inputComboBox.setMinimumSize(null);
    inputComboBox.setPreferredSize(null);

    javax.swing.GroupLayout inputPanelLayout = new javax.swing.GroupLayout(inputPanel);
    inputPanel.setLayout(inputPanelLayout);
    inputPanelLayout.setHorizontalGroup(
      inputPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, inputPanelLayout.createSequentialGroup()
        .addGap(15, 15, 15)
        .addGroup(inputPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addGroup(inputPanelLayout.createSequentialGroup()
            .addComponent(promptLabel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addGap(1, 1, 1))
          .addGroup(inputPanelLayout.createSequentialGroup()
            .addComponent(inputComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
            .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))))
    );
    inputPanelLayout.setVerticalGroup(
      inputPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(inputPanelLayout.createSequentialGroup()
        .addComponent(promptLabel)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(inputComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addGap(15, 15, 15))
    );

    iconLabel.setText(" ");

    spacerPanel.setMaximumSize(null);

    javax.swing.GroupLayout spacerPanelLayout = new javax.swing.GroupLayout(spacerPanel);
    spacerPanel.setLayout(spacerPanelLayout);
    spacerPanelLayout.setHorizontalGroup(
      spacerPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGap(0, 50, Short.MAX_VALUE)
    );
    spacerPanelLayout.setVerticalGroup(
      spacerPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGap(0, 0, Short.MAX_VALUE)
    );

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
        .addGap(15, 15, 15)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
          .addComponent(spacerPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(iconLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 50, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(inputPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
          .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
            .addGap(15, 15, 15)
            .addComponent(okButton)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(cancelButton)))
        .addGap(15, 15, 15))
    );

    layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {cancelButton, okButton});

    layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {iconLabel, spacerPanel});

    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addGap(15, 15, 15)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(inputPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(iconLabel))
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addGroup(layout.createSequentialGroup()
            .addGap(0, 0, Short.MAX_VALUE)
            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
              .addComponent(cancelButton)
              .addComponent(okButton)))
          .addComponent(spacerPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        .addGap(15, 15, 15))
    );

    layout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {iconLabel, inputPanel});

  }// </editor-fold>//GEN-END:initComponents

  private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
    closeDialog();
  }//GEN-LAST:event_formWindowClosing

  private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
    ok = true;
    inputIndex = inputComboBox.getSelectedIndex();
    final Object item = inputComboBox.getSelectedItem();
    input = item == null ? "" : item.toString();
    closeDialog();
  }//GEN-LAST:event_okButtonActionPerformed

  private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
    closeDialog();
  }//GEN-LAST:event_cancelButtonActionPerformed

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JButton cancelButton;
  private javax.swing.JLabel iconLabel;
  private javax.swing.JComboBox inputComboBox;
  private javax.swing.JPanel inputPanel;
  private javax.swing.JButton okButton;
  private javax.swing.JLabel promptLabel;
  private javax.swing.JPanel spacerPanel;
  // End of variables declaration//GEN-END:variables
}
