/*
 * Decompiled with CFR 0.152.
 */
package nintaco.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import nintaco.gui.IntPoint;

public final class StringUtil {
    private static SimpleDateFormat hhmmssFormat = new SimpleDateFormat("HH:mm:ss");

    private StringUtil() {
    }

    public static String getTimeString() {
        return hhmmssFormat.format(new Date());
    }

    public static Integer parseInt(Object value, boolean hex, long minValue, long maxValue) {
        int v;
        if (value == null) {
            return null;
        }
        String s = value.toString().trim();
        if (s.startsWith("$") || s.startsWith("x")) {
            s = s.substring(1);
            hex = true;
        } else if (s.startsWith("0x") || s.startsWith("&H") || s.startsWith("&h")) {
            s = s.substring(2);
            hex = true;
        }
        if (s.isEmpty() || s.equals("-") || hex && s.startsWith("-")) {
            return null;
        }
        try {
            v = Integer.parseInt(s, hex ? 16 : 10);
        }
        catch (Throwable t) {
            if (hex) {
                return null;
            }
            try {
                v = Integer.parseInt(s, 16);
            }
            catch (Throwable u) {
                return null;
            }
        }
        return (long)v < minValue || (long)v > maxValue ? null : Integer.valueOf(v);
    }

    public static int parseInt(Object value, boolean hex, long maxValue) {
        if (value == null) {
            return -1;
        }
        String s = value.toString().trim();
        if (s.startsWith("$") || s.startsWith("x")) {
            s = s.substring(1);
            hex = true;
        } else if (s.startsWith("0x") || s.startsWith("&H") || s.startsWith("&h")) {
            s = s.substring(2);
            hex = true;
        }
        if (s.isEmpty() || s.equals("-")) {
            return -1;
        }
        if (s.startsWith("-")) {
            return -2;
        }
        int v = 0;
        try {
            v = Integer.parseInt(s, hex ? 16 : 10);
        }
        catch (Throwable t) {
            if (hex) {
                return -3;
            }
            try {
                v = Integer.parseInt(s, 16);
            }
            catch (Throwable u) {
                return -3;
            }
        }
        return v < 0 || (long)v > maxValue ? -2 : v;
    }

    public static String makeEmpty(String str) {
        return StringUtil.isBlank(str) ? "" : str;
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static String replaceBlank(String value, String replacement) {
        return StringUtil.isBlank(value) ? replacement : value;
    }

    public static String replaceBlank(String value) {
        return StringUtil.replaceBlank(value, "");
    }

    public static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    public static String toYesNo(boolean value) {
        return value ? "yes" : "no";
    }

    public static void appendUnsignedInt(StringBuilder sb, int value) {
        StringUtil.appendUnsignedInt(sb, "%d", value);
    }

    public static void appendUnsignedInt(StringBuilder sb, String format, int value) {
        StringUtil.append(sb, format, (long)value & 0xFFFFFFFFL);
    }

    public static void append(StringBuilder sb, String line, Object ... args) {
        sb.append(String.format(line, args));
    }

    public static void appendLine(StringBuilder sb) {
        sb.append(System.lineSeparator());
    }

    public static void appendLine(StringBuilder sb, String line, Object ... args) {
        StringUtil.append(sb, line, args);
        StringUtil.appendLine(sb);
    }

    public static boolean compareStrings(String str1, int[] str2) {
        if (str1 == null || str2 == null || str1.length() > str2.length) {
            return false;
        }
        for (int i = str1.length() - 1; i >= 0; --i) {
            if (str1.charAt(i) == str2[i]) continue;
            return false;
        }
        return true;
    }

    public static String replaceNewlines(String str) {
        StringBuilder sb = new StringBuilder();
        boolean appendNewline = false;
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '\n' || ch == '\r') {
                appendNewline = true;
                continue;
            }
            if (appendNewline) {
                appendNewline = false;
                sb.append('\n');
            }
            sb.append(ch);
        }
        if (appendNewline) {
            appendNewline = false;
            sb.append('\n');
        }
        return sb.toString();
    }

    public static String removeNewlines(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '\n' || ch == '\r') continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String removeWhitespaces(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    public static int parseInt(String value) {
        return StringUtil.parseInt(value, 0);
    }

    public static int parseInt(String value, int defaultValue) {
        try {
            return StringUtil.isBlank(value) ? defaultValue : Integer.parseInt(value);
        }
        catch (Throwable t) {
            return defaultValue;
        }
    }

    public static int findMatch(String[] values, String target) {
        return StringUtil.findMatch(values, target, 0, values.length);
    }

    public static int findMatch(String[] values, String target, int offset, int length) {
        for (int i = length - 1; i >= 0; --i) {
            if (!target.equalsIgnoreCase(values[offset + i])) continue;
            return offset + i;
        }
        return -1;
    }

    public static int findContaining(String[] values, String keyword) {
        return StringUtil.findContaining(values, keyword, 0, values.length);
    }

    public static int findContaining(String[] values, String keyword, int offset, int length) {
        for (int i = length - 1; i >= 0; --i) {
            if (!values[offset + i].toLowerCase().contains(keyword)) continue;
            return offset + i;
        }
        return -1;
    }

    public static IntPoint getTextDimensions(String multilineString) {
        int maxLineLength = 0;
        int lineIndex = 0;
        int lines = 0;
        int b = 0;
        int length = multilineString.length();
        for (int i = 0; i <= length; ++i) {
            int c;
            int n = c = i == length ? 10 : (int)multilineString.charAt(i);
            if (c == 10 || c == 13) {
                if (b == 13 && c == 10 || b == 10 && c == 13) {
                    b = 0;
                } else {
                    maxLineLength = Math.max(i - lineIndex, maxLineLength);
                    ++lines;
                    b = c;
                }
                lineIndex = i + 1;
                continue;
            }
            b = c;
        }
        return new IntPoint(maxLineLength, lines);
    }

    public static interface ParseErrors {
        public static final int EMPTY = -1;
        public static final int OUT_OF_RANGE = -2;
        public static final int NOT_A_NUMBER = -3;
    }
}

