/*
 * Decompiled with CFR 0.152.
 */
package nintaco.util;

import java.security.SecureRandom;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import nintaco.util.CollectionsUtil;

public final class PasswordUtil {
    private static final int ITERATIONS = 16411;
    private static final int SALT_LENGTH = 32;
    private static final int KEY_LENGTH = 256;

    private PasswordUtil() {
    }

    public static byte[] createSalt() {
        try {
            return SecureRandom.getInstance("SHA1PRNG").generateSeed(32);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static byte[] createHash(char[] password, byte[] salt) {
        try {
            if (CollectionsUtil.isBlank(password) || CollectionsUtil.isBlank(salt)) {
                return null;
            }
            return SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1").generateSecret(new PBEKeySpec(password, salt, 16411, 256)).getEncoded();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static boolean compare(char[] enteredPassword, byte[] hash, byte[] salt) {
        try {
            if (CollectionsUtil.isBlank(enteredPassword) || CollectionsUtil.isBlank(hash) || CollectionsUtil.isBlank(salt)) {
                return false;
            }
            return CollectionsUtil.compareArrays(hash, PasswordUtil.createHash(enteredPassword, salt));
        }
        catch (Throwable t) {
            return false;
        }
    }
}

