/*
 * Decompiled with CFR 0.152.
 */
package nintaco.util;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import nintaco.files.FileUtil;

public final class InstanceUtil {
    private static File file;
    private static FileChannel fileChannel;
    private static FileLock lock;

    public static boolean isAlreadyRunning() {
        file = new File(FileUtil.appendSeparator(System.getProperty("java.io.tmpdir")) + "nintaco.lock");
        try {
            fileChannel = new RandomAccessFile(file, "rw").getChannel();
            lock = fileChannel.tryLock();
        }
        catch (Throwable t) {
            return false;
        }
        if (lock == null) {
            try {
                fileChannel.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return true;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(InstanceUtil::unlockFile));
        return false;
    }

    private static void unlockFile() {
        if (lock != null) {
            try {
                lock.release();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (fileChannel != null) {
            try {
                fileChannel.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (file != null) {
            try {
                file.delete();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private InstanceUtil() {
    }
}

