/*
 * Decompiled with CFR 0.152.
 */
package nintaco.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.imageio.ImageIO;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.PlainDocument;
import nintaco.App;
import nintaco.MessageException;
import nintaco.MessageTask;
import nintaco.files.FileUtil;
import nintaco.gui.AutocompleteFileChooser;
import nintaco.gui.FileExtensionFilter;
import nintaco.gui.InformationDialog;
import nintaco.gui.IntPoint;
import nintaco.gui.PleaseWaitDialog;
import nintaco.gui.StyleListener;
import nintaco.gui.TableCellClickedListener;
import nintaco.gui.YesNoDialog;
import nintaco.gui.image.ImageFrame;
import nintaco.gui.image.ImagePane;
import nintaco.gui.image.preferences.Paths;
import nintaco.gui.image.preferences.View;
import nintaco.preferences.AppPrefs;
import nintaco.util.InvocationContainer;
import nintaco.util.MathUtil;
import nintaco.util.StringUtil;

public final class GuiUtil {
    private static final String[] imageFileFormats = new String[]{"bmp", "gif", "jpg", "png"};
    private static final int SCREENSAVER_FRAMES = 1000;
    private static final Robot robot;
    private static int screensaverCounter;
    private static volatile boolean disableScreensaver;
    private static final List<Image> icons;
    private static Map<Class, String> fontKeys;
    public static final NoBorderLabelRenderer NO_BORDER_LABEL_RENDERER;
    public static final NoBorderBooleanRenderer NO_BORDER_BOOLEAN_RENDERER;
    public static final NoBorderMonospacedRenderer NO_BORDER_MONOSPACED_RENDERER;
    public static final CenteredLabelRenderer CENTERED_LABEL_RENDERER;
    public static final RightLabelRenderer RIGHT_LABEL_RENDERER;

    private GuiUtil() {
    }

    public static String[] getWritableImageFileFormats() {
        return imageFileFormats;
    }

    public static boolean isAlphaFormat(String fileFormat) {
        if (StringUtil.isBlank(fileFormat)) {
            return false;
        }
        return "png".equals(fileFormat = fileFormat.trim().toLowerCase()) || "gif".equals(fileFormat);
    }

    public static void displayError(Window parent, String message, Object ... parameters) {
        GuiUtil.displayError("Error", parent, message, parameters);
    }

    public static void displayError(String title, Window parent, String message, Object ... parameters) {
        GuiUtil.displayError(title, parent, String.format(message, parameters));
    }

    public static void displayError(Window parent, String message) {
        GuiUtil.displayError("Error", parent, message);
    }

    public static void displayError(String title, Window parent, String message) {
        GuiUtil.displayMessage(title, parent, message, InformationDialog.IconType.ERROR);
    }

    public static void displayInformation(String title, Window parent, String message) {
        GuiUtil.displayMessage(title, parent, message, InformationDialog.IconType.INFORMATION);
    }

    public static void displayMessage(String title, Window parent, String message, InformationDialog.IconType iconType) {
        if (EventQueue.isDispatchThread()) {
            if (!StringUtil.isBlank(message)) {
                App.setNoStepPause(true);
                InformationDialog dialog = new InformationDialog(parent, message, title, iconType);
                dialog.setVisible(true);
                App.setNoStepPause(false);
            }
        } else {
            EventQueue.invokeLater(() -> GuiUtil.displayMessage(title, parent, message, iconType));
        }
    }

    public static <T extends Component> List<T> findComponents(Class<T> c, Component component) {
        return GuiUtil.findComponents(new ArrayList(), c, component);
    }

    public static <T extends Component> List<T> findComponents(List<T> result, Class<T> c, Component component) {
        if (c.isAssignableFrom(component.getClass())) {
            result.add(c.cast(component));
        }
        if (component instanceof Container) {
            for (Component child : ((Container)component).getComponents()) {
                GuiUtil.findComponents(result, c, child);
            }
        }
        return result;
    }

    public static Font getDefaultFont(Component component) {
        String key = null;
        Class<?> c = component.getClass();
        while ((key = fontKeys.get(c)) == null && (c = c.getSuperclass()) != null && c != Component.class) {
        }
        if (key == null) {
            Font font = component.getFont();
            return font == null ? null : font.deriveFont(12.0f);
        }
        Font font = UIManager.getFont(key);
        if (font != null) {
            if (font.getSize() > 12) {
                font = font.deriveFont(12.0f);
            }
            if (GuiUtil.isMonospaced(component)) {
                font = new Font("Monospaced", font.getStyle(), font.getSize());
            }
        }
        return font;
    }

    public static void scaleMenuItemFont(JMenuItem menuItem) {
        Font font = GuiUtil.getDefaultFont(menuItem);
        if (font != null) {
            menuItem.setFont(font.deriveFont(font.getSize2D() * AppPrefs.getInstance().getView().getFontScale()));
        }
    }

    public static void scaleFonts(Component component) {
        if (component != null) {
            GuiUtil.scaleFonts(component, AppPrefs.getInstance().getView().getFontScale());
        }
    }

    public static void scaleFonts(Component component, float scale) {
        if (component != null) {
            Font f;
            Border border;
            Font font;
            if (component instanceof Window) {
                ((Window)component).setIconImages(icons);
            }
            if ((font = GuiUtil.getDefaultFont(component)) != null) {
                component.setFont(GuiUtil.scaleFont(font, scale));
            }
            if (component instanceof JMenu) {
                GuiUtil.scaleFonts(((JMenu)component).getPopupMenu(), scale);
            } else if (component instanceof JTable) {
                GuiUtil.scaleFonts(((JTable)component).getTableHeader(), scale);
            }
            if (component instanceof JComponent && (border = ((JComponent)component).getBorder()) instanceof TitledBorder && (f = UIManager.getFont("TitledBorder.font")) != null) {
                ((TitledBorder)border).setTitleFont(GuiUtil.scaleFont(f, scale));
            }
            if (component instanceof Container) {
                for (Component comp : ((Container)component).getComponents()) {
                    GuiUtil.scaleFonts(comp, scale);
                }
            }
        }
    }

    public static Font scaleFont(Font font) {
        return GuiUtil.scaleFont(font, AppPrefs.getInstance().getView().getFontScale());
    }

    public static Font scaleFont(Font font, float scale) {
        return font.deriveFont(font.getSize2D() * scale);
    }

    public static void resizeFonts(Component component, float size) {
        if (component != null) {
            Font font = GuiUtil.getDefaultFont(component);
            if (font != null) {
                component.setFont(font.deriveFont(size));
            }
            if (component instanceof JMenu) {
                GuiUtil.resizeFonts(((JMenu)component).getPopupMenu(), size);
            } else if (component instanceof JTable) {
                GuiUtil.resizeFonts(((JTable)component).getTableHeader(), size);
            }
            if (component instanceof Container) {
                for (Component comp : ((Container)component).getComponents()) {
                    GuiUtil.resizeFonts(comp, size);
                }
            }
        }
    }

    public static void repaint(Component component) {
        if (component != null) {
            component.repaint();
            if (component instanceof JMenu) {
                GuiUtil.repaint(((JMenu)component).getPopupMenu());
            } else if (component instanceof JTable) {
                GuiUtil.repaint(((JTable)component).getTableHeader());
            }
            if (component instanceof Container) {
                for (Component comp : ((Container)component).getComponents()) {
                    GuiUtil.repaint(comp);
                }
            }
        }
    }

    public static void resizeCellSizes(JTable table, boolean includeVerticleScrollBarWidth, int minimumVisibleRows, boolean limitVisibleRowsToModelSize, Object ... prototypeValues) {
        GuiUtil.resizeCellSizes(table, true, includeVerticleScrollBarWidth, minimumVisibleRows, limitVisibleRowsToModelSize, prototypeValues);
    }

    public static void resizeCellSizes(JTable table, boolean includeHeaderIcons, boolean includeVerticleScrollBarWidth, int minimumVisibleRows, boolean limitVisibleRowsToModelSize, Object ... prototypeValues) {
        Icon icon = UIManager.getIcon("Table.ascendingSortIcon");
        TableColumnModel columnModel = table.getColumnModel();
        int height = 0;
        int totalWidth = 0;
        for (int column = 0; column < table.getColumnCount(); ++column) {
            TableCellRenderer renderer;
            Dimension size;
            Component comp;
            TableColumn col = columnModel.getColumn(column);
            int width = 0;
            if (column < prototypeValues.length) {
                TableCellRenderer cellRenderer = col.getCellRenderer();
                if (cellRenderer == null) {
                    cellRenderer = table.getDefaultRenderer(table.getModel().getColumnClass(column));
                }
                comp = (JComponent)cellRenderer.getTableCellRendererComponent(table, prototypeValues[column], false, false, 0, column);
                GuiUtil.scaleFonts(comp);
                size = ((JComponent)comp).getPreferredSize();
                width = size.width;
                height = Math.max(size.height, height);
            }
            if ((renderer = col.getHeaderRenderer()) == null) {
                renderer = table.getTableHeader().getDefaultRenderer();
            }
            comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
            if (includeHeaderIcons && comp instanceof JLabel) {
                ((JLabel)comp).setIcon(icon);
            }
            GuiUtil.scaleFonts(comp);
            size = comp.getPreferredSize();
            width = Math.max(size.width, width) + 4;
            col.setPreferredWidth(width);
            col.setMinWidth(width);
            col.setWidth(width);
            totalWidth += width;
        }
        if (table.getAutoResizeMode() == 3) {
            columnModel.getColumn(columnModel.getColumnCount() - 1).setPreferredWidth(100000);
        }
        table.setRowHeight(height);
        if (includeVerticleScrollBarWidth) {
            JViewport parent = (JViewport)table.getParent();
            JScrollPane scrollPane = (JScrollPane)parent.getParent();
            totalWidth += scrollPane.getVerticalScrollBar().getPreferredSize().width;
        }
        table.setPreferredScrollableViewportSize(new Dimension(totalWidth, (limitVisibleRowsToModelSize ? Math.min(minimumVisibleRows, table.getRowCount()) : minimumVisibleRows) * height));
    }

    public static void resizeCellSizes(JTable table) {
        GuiUtil.resizeCellSizes(table, false, 10, true);
    }

    public static void setTextAreaSize(JTextArea textArea, int rows, int columns) {
        JScrollPane scrollPane = (JScrollPane)((JViewport)textArea.getParent()).getParent();
        Insets i1 = scrollPane.getInsets();
        Insets i2 = textArea.getInsets();
        FontMetrics metrics = textArea.getFontMetrics(textArea.getFont());
        scrollPane.setPreferredSize(new Dimension(metrics.charWidth('M') * columns + scrollPane.getVerticalScrollBar().getPreferredSize().width + i1.left + i1.right + i2.left + i2.right, metrics.getHeight() * rows + scrollPane.getHorizontalScrollBar().getPreferredSize().height + i1.top + i1.bottom + i2.top + i2.bottom));
    }

    public static void setPanelPreferredSize(Component component) {
        Dimension size = component.getPreferredSize();
        JScrollPane scrollPane = (JScrollPane)((JViewport)component.getParent()).getParent();
        JPanel panel = (JPanel)scrollPane.getParent();
        panel.setPreferredSize(new Dimension(5 + size.width + scrollPane.getVerticalScrollBar().getPreferredSize().width, 5 + size.height + scrollPane.getHorizontalScrollBar().getPreferredSize().height));
    }

    public static void resizeCellSizes(JTable table, boolean includeVerticleScrollBarWidth, int minimumVisibleRows, boolean limitVisibleRowsToModelSize) {
        if (table.getRowCount() == 0) {
            return;
        }
        Icon icon = UIManager.getIcon("Table.ascendingSortIcon");
        TableColumnModel columnModel = table.getColumnModel();
        int height = 0;
        int totalWidth = 0;
        for (int column = 0; column < table.getColumnCount(); ++column) {
            Dimension size;
            Component comp;
            TableCellRenderer renderer;
            int width = 0;
            for (int row = table.getRowCount() - 1; row >= 0; --row) {
                renderer = table.getCellRenderer(row, column);
                comp = table.prepareRenderer(renderer, row, column);
                GuiUtil.scaleFonts(comp);
                size = comp.getPreferredSize();
                width = Math.max(size.width, width);
                height = Math.max(size.height, height);
            }
            TableColumn col = columnModel.getColumn(column);
            renderer = col.getHeaderRenderer();
            if (renderer == null) {
                renderer = table.getTableHeader().getDefaultRenderer();
            }
            if ((comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0)) instanceof JLabel) {
                ((JLabel)comp).setIcon(icon);
            }
            GuiUtil.scaleFonts(comp);
            size = comp.getPreferredSize();
            width = Math.max(size.width, width);
            col.setPreferredWidth(width + 4);
            col.setMinWidth(width + 4);
            col.setWidth(width + 4);
            totalWidth += width;
        }
        table.setRowHeight(height);
        if (includeVerticleScrollBarWidth) {
            JViewport parent = (JViewport)table.getParent();
            JScrollPane scrollPane = (JScrollPane)parent.getParent();
            totalWidth += scrollPane.getVerticalScrollBar().getPreferredSize().width;
        }
        table.setPreferredScrollableViewportSize(new Dimension(totalWidth, (limitVisibleRowsToModelSize ? Math.min(minimumVisibleRows, table.getRowCount()) : minimumVisibleRows) * height));
    }

    public static void disableCellBorder(JTable table) {
        table.setDefaultRenderer(String.class, NO_BORDER_LABEL_RENDERER);
        table.setDefaultRenderer(Boolean.class, NO_BORDER_BOOLEAN_RENDERER);
    }

    public static void forceNoClearRowSelect(JTable table) {
        table.setSelectionModel(new NoClearSelectionModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean executeMessageTask(Window window, PleaseWaitDialog pleaseWaitDialog, MessageTask task) {
        String errorMessage = null;
        try {
            task.execute();
        }
        catch (MessageException e) {
            errorMessage = e.getMessage();
        }
        finally {
            pleaseWaitDialog.dispose();
            App.setNoStepPause(false);
        }
        if (errorMessage != null) {
            GuiUtil.displayError(window, errorMessage);
            return false;
        }
        return true;
    }

    public static void toFront(JDialog dialog) {
        if (EventQueue.isDispatchThread()) {
            dialog.setVisible(true);
            dialog.setAlwaysOnTop(true);
            dialog.toFront();
            dialog.requestFocus();
            dialog.setAlwaysOnTop(false);
        } else {
            EventQueue.invokeLater(() -> GuiUtil.toFront(dialog));
        }
    }

    public static void toFront(JFrame frame) {
        if (EventQueue.isDispatchThread()) {
            frame.setVisible(true);
            frame.setExtendedState(frame.getExtendedState() & 0xFFFFFFFE);
            frame.setAlwaysOnTop(true);
            frame.toFront();
            frame.requestFocus();
            frame.setAlwaysOnTop(false);
        } else {
            EventQueue.invokeLater(() -> GuiUtil.toFront(frame));
        }
    }

    public static void setClipboardString(Object value) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(value.toString()), null);
    }

    public static String getClipboardString() {
        String result = null;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clipboard.getContents(null);
        if (contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                result = (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    public static int showSaveDialog(Component parent, JFileChooser chooser) {
        return GuiUtil.showSaveDialog(parent, chooser, null);
    }

    public static int showOpenDialog(Component parent, JFileChooser chooser) {
        return GuiUtil.showOpenDialog(parent, chooser, null);
    }

    public static int showSaveDialog(Component parent, JFileChooser chooser, BiConsumer<Paths, String> saveDirectoryConsumer) {
        return GuiUtil.showFileChooser(parent, chooser, saveDirectoryConsumer, 1);
    }

    public static int showOpenDialog(Component parent, JFileChooser chooser, BiConsumer<Paths, String> saveDirectoryConsumer) {
        return GuiUtil.showFileChooser(parent, chooser, saveDirectoryConsumer, 0);
    }

    public static int showFileChooser(Component parent, JFileChooser chooser, BiConsumer<Paths, String> saveDirectoryConsumer, int dialogType) {
        chooser.setDialogType(dialogType);
        int result = chooser.showDialog(parent, null);
        AppPrefs prefs = AppPrefs.getInstance();
        prefs.getView().setFileChooserSize(chooser.getSize());
        if (result == 0) {
            String dir;
            Paths paths = prefs.getPaths();
            File selectedFile = chooser.getSelectedFile();
            if (selectedFile != null && (dir = selectedFile.getParent()) != null && saveDirectoryConsumer != null) {
                paths.addRecentDirectory(dir);
                saveDirectoryConsumer.accept(paths, dir);
            }
        }
        AppPrefs.save();
        return result;
    }

    public static JFileChooser createFileChooser(String title, String directory, FileFilter ... fileFilters) {
        return new AutocompleteFileChooser(title, directory, fileFilters);
    }

    public static JFileChooser createFileChooser(String title, File directory, FileFilter ... fileFilters) {
        return new AutocompleteFileChooser(title, directory, fileFilters);
    }

    public static File showSaveAsDialog(Window parent, String saveDirectory, String fileName, String fileExtension, FileFilter fileFilter, boolean promptOverwrite) {
        return GuiUtil.showSaveAsDialog(parent, saveDirectory, fileName, fileExtension, fileFilter, promptOverwrite, "Save As");
    }

    public static File showSaveAsDialog(Window parent, String saveDirectory, String fileName, String fileExtension, FileFilter fileFilter, boolean promptOverwrite, String title) {
        block6: {
            YesNoDialog yesNoDialog;
            boolean showPrompt;
            File saveDir = new File(saveDirectory);
            File file = null;
            do {
                AutocompleteFileChooser chooser = new AutocompleteFileChooser(title, saveDir, fileFilter);
                if (fileFilter == null) {
                    chooser.setFileSelectionMode(1);
                    chooser.addChoosableFileFilter(new FileExtensionFilter(0, "All directories"));
                }
                if (fileName == null) {
                    chooser.setSelectedFile(new File(saveDirectory));
                } else {
                    chooser.setSelectedFile(FileUtil.getFile(saveDir, fileName));
                }
                int result = ((JFileChooser)chooser).showSaveDialog(parent);
                AppPrefs.getInstance().getView().setFileChooserSize(chooser.getSize());
                AppPrefs.save();
                if (result != 0) break block6;
                file = chooser.getSelectedFile();
                fileName = file.getName();
                saveDir = file.getParentFile();
                if (!file.exists() && FileUtil.getFileExtension(file).trim().isEmpty()) {
                    String name = file.getPath();
                    if (!name.endsWith(".")) {
                        name = name + ".";
                    }
                    file = new File(name + fileExtension);
                }
                showPrompt = promptOverwrite && file.exists() && fileFilter != null;
                yesNoDialog = null;
                if (!showPrompt) continue;
                yesNoDialog = new YesNoDialog(parent, "Overwrite existing file?", "Confirm File Replace");
                yesNoDialog.setVisible(true);
            } while (showPrompt && !yesNoDialog.isYes());
            return file;
        }
        return null;
    }

    public static boolean confirmOverwrite(Window parent, String fileName) {
        if (fileName == null) {
            return false;
        }
        if ((fileName = fileName.trim()).length() == 0) {
            return false;
        }
        if (new File(fileName).exists()) {
            YesNoDialog yesNoDialog = new YesNoDialog(parent, "Overwrite existing file?", "Confirm File Replace");
            yesNoDialog.setVisible(true);
            if (yesNoDialog.isNo()) {
                return false;
            }
        }
        return true;
    }

    public static void addLoseFocusListener(Window window, JTextField textField) {
        textField.addActionListener(e -> window.requestFocusInWindow());
    }

    public static void addLoseFocusListener(final Window window, JSpinner spinner) {
        ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    window.requestFocusInWindow();
                }
            }
        });
    }

    public static DocumentListener createDocumentListener(final Runnable runnable) {
        return new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                runnable.run();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                runnable.run();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                runnable.run();
            }
        };
    }

    public static void addTextFieldEditListener(JTextField textField, Runnable runnable) {
        textField.getDocument().addDocumentListener(GuiUtil.createDocumentListener(runnable));
    }

    public static void addSpinnerEditListener(JSpinner spinner, Runnable runnable) {
        ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().getDocument().addDocumentListener(GuiUtil.createDocumentListener(runnable));
    }

    public static int getFirstVisibleRowIndex(JTable table) {
        TableModel model = table.getModel();
        if (model.getRowCount() == 0 || model.getColumnCount() == 0 || !(table.getParent() instanceof JViewport)) {
            return 0;
        }
        JViewport viewport = (JViewport)table.getParent();
        Point p = viewport.getViewPosition();
        Rectangle r = table.getCellRect(0, 0, true);
        if (r.height == 0) {
            return 0;
        }
        return MathUtil.roundUpDivision(p.y, r.height);
    }

    private static void scrollTo(int y, int rowCount, JViewport viewport, Rectangle r, Rectangle viewRect) {
        viewport.setViewPosition(new Point(0, MathUtil.clamp(y, 0, Math.max(0, rowCount * r.height - viewRect.height))));
    }

    public static void scrollToCenter(JTable table, int rowIndex) {
        TableModel model = table.getModel();
        int rowCount = model.getRowCount();
        if (rowCount == 0 || model.getColumnCount() == 0 || !(table.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)table.getParent();
        Rectangle r = table.getCellRect(0, 0, true);
        Point p = new Point(0, rowIndex * r.height);
        Rectangle viewRect = viewport.getViewRect();
        GuiUtil.scrollTo(p.y + (r.height - viewRect.height) / 2, rowCount, viewport, r, viewRect);
    }

    public static void scrollToCenter(JList list, int rowIndex) {
        ListModel model = list.getModel();
        int rowCount = model.getSize();
        if (rowCount == 0 || !(list.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)list.getParent();
        Rectangle r = list.getCellBounds(0, 0);
        Point p = new Point(0, rowIndex * r.height);
        Rectangle viewRect = viewport.getViewRect();
        GuiUtil.scrollTo(p.y + (r.height - viewRect.height) / 2, rowCount, viewport, r, viewRect);
    }

    public static void scrollToVisible(JTable table, int rowIndex) {
        TableModel model = table.getModel();
        int rowCount = model.getRowCount();
        if (rowCount == 0 || model.getColumnCount() == 0 || !(table.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)table.getParent();
        Rectangle r = table.getCellRect(0, 0, true);
        Point p = new Point(0, rowIndex * r.height);
        Rectangle viewRect = viewport.getViewRect();
        if (p.y < viewRect.y) {
            GuiUtil.scrollTo(p.y, rowCount, viewport, r, viewRect);
        } else {
            int py1 = p.y + r.height;
            int vy1 = viewRect.y + viewRect.height;
            if (py1 > vy1) {
                GuiUtil.scrollTo(py1 - viewRect.height, rowCount, viewport, r, viewRect);
            }
        }
    }

    public static void scrollToVisible(JList list, int rowIndex) {
        ListModel model = list.getModel();
        int rowCount = model.getSize();
        if (rowCount == 0 || !(list.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)list.getParent();
        Rectangle r = list.getCellBounds(0, 0);
        Point p = new Point(0, rowIndex * r.height);
        Rectangle viewRect = viewport.getViewRect();
        if (p.y < viewRect.y) {
            GuiUtil.scrollTo(p.y, rowCount, viewport, r, viewRect);
        } else {
            int py1 = p.y + r.height;
            int vy1 = viewRect.y + viewRect.height;
            if (py1 > vy1) {
                GuiUtil.scrollTo(py1 - viewRect.height, rowCount, viewport, r, viewRect);
            }
        }
    }

    public static void scrollToRowIndex(JTable table, int rowIndex) {
        TableModel model = table.getModel();
        int rowCount = model.getRowCount();
        if (rowCount == 0 || model.getColumnCount() == 0 || !(table.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)table.getParent();
        Rectangle r = table.getCellRect(0, 0, true);
        Rectangle viewRect = viewport.getViewRect();
        GuiUtil.scrollTo(rowIndex * r.height, rowCount, viewport, r, viewRect);
    }

    public static void makeMonospaced(Component component) {
        component.setName("Monospaced");
        component.setFont(new Font("Monospaced", 0, GuiUtil.getDefaultFont(component).getSize()));
    }

    public static boolean isMonospaced(Component component) {
        Font font = component.getFont();
        if (font == null) {
            return false;
        }
        return "Monospaced".equals(font.getFamily()) || "Monospaced".equals(component.getName());
    }

    public static void limitTextFieldLength(JTextField textField, final int maxLength) {
        textField.setDocument(new PlainDocument(){

            @Override
            public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
                if (str != null && this.getLength() + str.length() <= maxLength) {
                    super.insertString(offset, str, attr);
                }
            }
        });
    }

    public static int parseTextField(JTextField textField, int emptyValue, int minValue, int maxValue) {
        int value;
        try {
            value = Integer.parseInt(textField.getText().trim());
        }
        catch (Throwable t) {
            value = emptyValue;
        }
        if (value < minValue) {
            value = minValue;
        } else if (value > maxValue) {
            value = maxValue;
        }
        textField.setText(Integer.toString(value));
        return value;
    }

    public static int getCaretRow(JTextArea textArea) {
        try {
            return textArea.getLineOfOffset(textArea.getCaretPosition());
        }
        catch (Throwable t) {
            return -1;
        }
    }

    public static int getCaretColumn(JTextArea textArea, int row) {
        try {
            return textArea.getCaretPosition() - textArea.getLineStartOffset(row);
        }
        catch (Throwable t) {
            return -1;
        }
    }

    public static void showCursor(JTextArea textArea) {
        Caret caret = textArea.getCaret();
        caret.setVisible(true);
        caret.setSelectionVisible(true);
    }

    public static void hideCursor(JTextArea textArea) {
        textArea.getCaret().setVisible(false);
    }

    public static void setCellRenderer(JTable table, int startColumnIndex, int endColumnIndex, TableCellRenderer renderer) {
        for (int i = startColumnIndex; i <= endColumnIndex; ++i) {
            GuiUtil.setCellRenderer(table, i, renderer);
        }
    }

    public static void setCellRenderer(JTable table, int columnIndex, TableCellRenderer renderer) {
        table.getColumnModel().getColumn(columnIndex).setCellRenderer(renderer);
    }

    public static void createComboBoxCellEditorAndRenderer(JTable table, int columnIndex, String[] items) {
        TableColumn column = table.getColumnModel().getColumn(columnIndex);
        column.setCellEditor(new DefaultCellEditor(new JComboBox<String>(items)));
        column.setCellRenderer(new TableCellComboBoxRenderer(items));
    }

    public static void centerTableHeaders(JTable table) {
        ((DefaultTableCellRenderer)table.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(0);
    }

    public static void addTableCellClickedListener(JTable table, TableCellClickedListener listener) {
        TableMouseAdapter adapter = new TableMouseAdapter(table, listener);
        table.addMouseListener(adapter);
        table.addMouseMotionListener(adapter);
    }

    public static void removeTransferActions(JComponent component) {
        component.setTransferHandler(null);
    }

    public static IntPoint getScrollValues(JScrollPane scrollPane) {
        return new IntPoint(scrollPane.getHorizontalScrollBar().getValue(), scrollPane.getVerticalScrollBar().getValue());
    }

    public static void setScrollValues(JScrollPane scrollPane, IntPoint values) {
        scrollPane.getHorizontalScrollBar().setValue(values.getX());
        scrollPane.getVerticalScrollBar().setValue(values.getY());
    }

    public static void enableAutoscroll(JTextArea textArea) {
        ((DefaultCaret)textArea.getCaret()).setUpdatePolicy(2);
    }

    public static <T extends Enum<T>> void populateComboBox(JComboBox comboBox, Class<T> c) {
        DefaultComboBoxModel<Enum> model = new DefaultComboBoxModel<Enum>();
        for (Enum enumValue : (Enum[])c.getEnumConstants()) {
            model.addElement(enumValue);
        }
        comboBox.setModel(model);
    }

    public static Insets getScreenInsets(Window windowOrNull) {
        Insets insets = windowOrNull == null ? Toolkit.getDefaultToolkit().getScreenInsets(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration()) : windowOrNull.getToolkit().getScreenInsets(windowOrNull.getGraphicsConfiguration());
        return insets;
    }

    public static Rectangle getScreenWorkingArea(Window windowOrNull) {
        Rectangle bounds;
        Insets insets;
        if (windowOrNull == null) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            insets = Toolkit.getDefaultToolkit().getScreenInsets(ge.getDefaultScreenDevice().getDefaultConfiguration());
            bounds = ge.getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        } else {
            GraphicsConfiguration gc = windowOrNull.getGraphicsConfiguration();
            insets = windowOrNull.getToolkit().getScreenInsets(gc);
            bounds = gc.getBounds();
        }
        bounds.x += insets.left;
        bounds.y += insets.top;
        bounds.width -= insets.left + insets.right;
        bounds.height -= insets.top + insets.bottom;
        return bounds;
    }

    public static Rectangle getScreenTotalArea(Window windowOrNull) {
        Rectangle bounds;
        if (windowOrNull == null) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            bounds = ge.getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        } else {
            GraphicsConfiguration gc = windowOrNull.getGraphicsConfiguration();
            bounds = gc.getBounds();
        }
        return bounds;
    }

    public static void setDisableScreensaver(boolean disableScreensaver) {
        GuiUtil.disableScreensaver = disableScreensaver;
    }

    public static void suppressScreensaver() {
        if (--screensaverCounter <= 0) {
            screensaverCounter = 1000;
            if (disableScreensaver) {
                robot.mouseWheel(0);
            }
        }
    }

    public static void normalize(Frame frame) {
        frame.setExtendedState(frame.getExtendedState() & 0xFFFFFFF9);
        EventQueue.invokeLater(() -> {
            frame.invalidate();
            frame.validate();
            frame.repaint();
        });
    }

    public static void maxipack(Frame frame) {
        if (GuiUtil.isMaximized(frame)) {
            frame.setExtendedState(0);
            GuiUtil.maximize(frame);
        } else {
            frame.pack();
        }
        EventQueue.invokeLater(() -> {
            frame.invalidate();
            frame.validate();
            frame.repaint();
        });
    }

    public static void maximize(Frame frame) {
        frame.setExtendedState(frame.getExtendedState() | 6);
        EventQueue.invokeLater(() -> {
            frame.invalidate();
            frame.validate();
            frame.repaint();
        });
    }

    public static boolean isMaximized(Frame frame) {
        return (frame.getExtendedState() & 6) != 0;
    }

    public static void scrollToBottom(JTextArea textArea) {
        textArea.setCaretPosition(textArea.getDocument().getLength());
    }

    public static void scrollToBottom(JScrollPane scrollPane) {
        JScrollBar vertical = scrollPane.getVerticalScrollBar();
        vertical.setValue(vertical.getMaximum());
    }

    public static void showAllRows(JTable table) {
        table.setPreferredScrollableViewportSize(table.getPreferredSize());
    }

    public static Cursor getCursor(String name, Point hotSpot) {
        return Toolkit.getDefaultToolkit().createCustomCursor(GuiUtil.getImageIcon(name).getImage(), hotSpot, name);
    }

    public static ImageIcon getImageIcon(String name) {
        return new ImageIcon(GuiUtil.class.getClassLoader().getResource(name));
    }

    public static BufferedImage loadImage(String name) {
        try {
            return ImageIO.read(GuiUtil.class.getClassLoader().getResource(name));
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static void setMetalLookAndFeel(MetalTheme theme) {
        try {
            Dimension imagePaneSize = App.getImageFrame().getImagePane().getPreferredSize();
            MetalLookAndFeel.setCurrentTheme(theme);
            UIManager.setLookAndFeel(new MetalLookAndFeel());
            View view = AppPrefs.getInstance().getView();
            view.setLookAndFeelClassName(MetalLookAndFeel.class.getCanonicalName());
            view.setThemeClassName(theme.getClass().getCanonicalName());
            GuiUtil.enableTableGridlines();
            GuiUtil.updateFrameStyles();
            AppPrefs.save();
            GuiUtil.resizeImagePane(imagePaneSize);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setLookAndFeel(String className) {
        try {
            Dimension imagePaneSize = App.getImageFrame().getImagePane().getPreferredSize();
            UIManager.setLookAndFeel(className);
            View view = AppPrefs.getInstance().getView();
            view.setLookAndFeelClassName(className);
            view.setThemeClassName(null);
            GuiUtil.enableTableGridlines();
            GuiUtil.updateFrameStyles();
            AppPrefs.save();
            GuiUtil.resizeImagePane(imagePaneSize);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void resizeImagePane(Dimension imagePaneSize) {
        EventQueue.invokeLater(() -> {
            ImageFrame imageFrame = App.getImageFrame();
            ImagePane imagePane = imageFrame.getImagePane();
            imagePane.setSize(imagePaneSize);
            imagePane.paneResized();
            imageFrame.pack();
        });
    }

    private static void enableTableGridlines() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        defaults.put("Table.disabled", (Object)false);
        defaults.put("Table.showGrid", (Object)true);
        defaults.put("Table.intercellSpacing", new Dimension(1, 1));
    }

    public static void updateFrameStyles() {
        for (Window window : Window.getWindows()) {
            SwingUtilities.updateComponentTreeUI(window);
            GuiUtil.scaleFonts(window);
            if (window instanceof StyleListener) {
                ((StyleListener)((Object)window)).styleChanged();
            }
            window.pack();
            window.setSize(window.getSize());
            window.invalidate();
            window.validate();
            window.repaint();
        }
    }

    public static void requestVsync(JFrame frame, boolean enableVsync) {
        if (EventQueue.isDispatchThread()) {
            boolean frameDisplayable = frame.isDisplayable();
            if (frameDisplayable) {
                frame.dispose();
            }
            try {
                Class<?> c = Class.forName("com.sun.java.swing.SwingUtilities3");
                Method m = c.getMethod("setVsyncRequested", Container.class, Boolean.TYPE);
                m.invoke(c, frame, AppPrefs.getInstance().getUserInterfacePrefs().isUseVsync() ? enableVsync : false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (frameDisplayable) {
                GuiUtil.toFront(frame);
            }
        } else {
            EventQueue.invokeLater(() -> GuiUtil.requestVsync(frame, enableVsync));
        }
    }

    public static void drawRect(int[] screen, int x, int y, int width, int height, int color) {
        int x2 = x + width - 1;
        int y2 = y + height - 1;
        GuiUtil.drawHorizontalLine(screen, x, x2, y, color);
        GuiUtil.drawHorizontalLine(screen, x, x2, y2, color);
        if (height >= 2) {
            GuiUtil.drawVerticalLine(screen, x, y + 1, y2 - 1, color);
            GuiUtil.drawVerticalLine(screen, x2, y + 1, y2 - 1, color);
        }
    }

    public static void drawHorizontalLine(int[] screen, int x1, int x2, int y, int color) {
        if (y < 0 || y > 239) {
            return;
        }
        y <<= 8;
        if (x1 > x2) {
            int t = x1;
            x1 = x2;
            x2 = t;
        }
        if (x2 < 0 || x1 > 255) {
            return;
        }
        int xMin = x1 < 0 ? 0 : x1;
        int xMax = x2 > 255 ? 255 : x2;
        for (int x = xMin; x <= xMax; ++x) {
            screen[y | x] = color;
        }
    }

    public static void drawVerticalLine(int[] screen, int x, int y1, int y2, int color) {
        if (x < 0 || x > 255) {
            return;
        }
        if (y1 > y2) {
            int t = y1;
            y1 = y2;
            y2 = t;
        }
        if (y2 < 0 || y1 > 239) {
            return;
        }
        int yMin = y1 < 0 ? 0 : y1;
        int yMax = y2 > 239 ? 239 : y2;
        for (int y = yMin; y <= yMax; ++y) {
            screen[y << 8 | x] = color;
        }
    }

    public static void invokeAndWait(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static <T> T invokeAndWait(Invocation<T> invocation) {
        InvocationContainer container = new InvocationContainer();
        GuiUtil.invokeAndWait(() -> container.setObject(invocation.run()));
        return container.getObject();
    }

    public static boolean sharesGraphicsDevice(Component c1, Component c2) {
        return c1 != null && c2 != null && Objects.equals(c1.getGraphicsConfiguration().getDevice(), c2.getGraphicsConfiguration().getDevice());
    }

    public static void moveToImageFrameMonitor(Window window) {
        GraphicsDevice screenDevice;
        ImageFrame imageFrame = App.getImageFrame();
        if (imageFrame != null && (screenDevice = imageFrame.getGraphicsConfiguration().getDevice()) != null) {
            Rectangle screenBounds = screenDevice.getDefaultConfiguration().getBounds();
            window.setLocation(screenBounds.x, screenBounds.y);
        }
    }

    public static GraphicsDevice getNextGraphicsDevice(Window window) {
        int i;
        GraphicsDevice[] sds = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        GraphicsDevice[] screenDevices = new GraphicsDevice[sds.length];
        System.arraycopy(sds, 0, screenDevices, 0, sds.length);
        Arrays.sort(screenDevices, (a, b) -> a.getIDstring().compareToIgnoreCase(b.getIDstring()));
        GraphicsDevice graphicsDevice = window.getGraphicsConfiguration().getDevice();
        int index = -1;
        for (i = screenDevices.length - 1; i >= 0; --i) {
            if (!Objects.equals(screenDevices[i], graphicsDevice)) continue;
            index = i;
            break;
        }
        if (index < 0) {
            return null;
        }
        for (i = 1; i < screenDevices.length; ++i) {
            GraphicsDevice device = screenDevices[(index + i) % screenDevices.length];
            if (!device.isFullScreenSupported()) continue;
            return device;
        }
        return null;
    }

    public static GraphicsDevice moveToGraphicsDevice(Window window, GraphicsDevice device) {
        if (window == null || device == null) {
            return null;
        }
        GraphicsDevice windowDevice = window.getGraphicsConfiguration().getDevice();
        if (Objects.equals(windowDevice, device)) {
            if (!window.isVisible()) {
                window.setVisible(true);
            }
            return windowDevice;
        }
        Rectangle windowDeviceBounds = windowDevice.getDefaultConfiguration().getBounds();
        Rectangle devicebounds = device.getDefaultConfiguration().getBounds();
        Point p = window.getLocation();
        window.dispose();
        window.setLocation((int)Math.round(devicebounds.getX() + (p.getX() - windowDeviceBounds.getX()) * (double)devicebounds.width / (double)windowDeviceBounds.width), (int)Math.round(devicebounds.getY() + (p.getY() - windowDeviceBounds.getY()) * (double)devicebounds.height / (double)windowDeviceBounds.height));
        window.setVisible(true);
        return windowDevice;
    }

    public static void forwardKeyEvents(Component from, final Component to) {
        from.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                e.setSource(to);
                to.dispatchEvent(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                e.setSource(to);
                to.dispatchEvent(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                e.setSource(to);
                to.dispatchEvent(e);
            }
        });
    }

    static {
        Robot r = null;
        try {
            r = new Robot();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        robot = r;
        icons = new ArrayList<Image>();
        for (int i : new int[]{16, 20, 24, 32, 40, 48, 64, 96, 128, 256}) {
            icons.add(GuiUtil.loadImage(String.format("nintaco/gui/icons/icon-%d.png", i)));
        }
        fontKeys = new HashMap<Class, String>();
        fontKeys.put(BasicArrowButton.class, "ArrowButton.font");
        fontKeys.put(JButton.class, "Button.font");
        fontKeys.put(JCheckBox.class, "CheckBox.font");
        fontKeys.put(JCheckBoxMenuItem.class, "CheckBoxMenuItem.font");
        fontKeys.put(JColorChooser.class, "ColorChooser.font");
        fontKeys.put(JComboBox.class, "ComboBox.font");
        fontKeys.put(JInternalFrame.JDesktopIcon.class, "DesktopIcon.font");
        fontKeys.put(JDesktopPane.class, "DesktopPane.font");
        fontKeys.put(JEditorPane.class, "EditorPane.font");
        fontKeys.put(JFileChooser.class, "FileChooser.font");
        fontKeys.put(JFormattedTextField.class, "FormattedTextField.font");
        fontKeys.put(JInternalFrame.class, "InternalFrame.font");
        fontKeys.put(BasicInternalFrameTitlePane.class, "InternalFrameTitlePane.font");
        fontKeys.put(JLabel.class, "Label.font");
        fontKeys.put(JList.class, "List.font");
        fontKeys.put(JMenu.class, "Menu.font");
        fontKeys.put(JMenuBar.class, "MenuBar.font");
        fontKeys.put(JMenuItem.class, "MenuItem.font");
        fontKeys.put(JOptionPane.class, "OptionPane.font");
        fontKeys.put(JPanel.class, "Panel.font");
        fontKeys.put(JPasswordField.class, "PasswordField.font");
        fontKeys.put(JPopupMenu.class, "PopupMenu.font");
        fontKeys.put(JPopupMenu.Separator.class, "PopupMenuSeparator.font");
        fontKeys.put(JProgressBar.class, "ProgressBar.font");
        fontKeys.put(JRadioButton.class, "RadioButton.font");
        fontKeys.put(JRadioButtonMenuItem.class, "RadioButtonMenuItem.font");
        fontKeys.put(JRootPane.class, "RootPane.font");
        fontKeys.put(JScrollBar.class, "ScrollBar.font");
        fontKeys.put(JScrollPane.class, "ScrollPane.font");
        fontKeys.put(JSeparator.class, "Separator.font");
        fontKeys.put(JSlider.class, "Slider.font");
        fontKeys.put(JSpinner.class, "Spinner.font");
        fontKeys.put(JSplitPane.class, "SplitPane.font");
        fontKeys.put(JTabbedPane.class, "TabbedPane.font");
        fontKeys.put(JTable.class, "Table.font");
        fontKeys.put(JTableHeader.class, "TableHeader.font");
        fontKeys.put(JTextArea.class, "TextArea.font");
        fontKeys.put(JTextField.class, "TextField.font");
        fontKeys.put(JTextPane.class, "TextPane.font");
        fontKeys.put(TitledBorder.class, "TitledBorder.font");
        fontKeys.put(JToggleButton.class, "ToggleButton.font");
        fontKeys.put(JToolBar.class, "ToolBar.font");
        fontKeys.put(JToolTip.class, "ToolTip.font");
        fontKeys.put(JTree.class, "Tree.font");
        fontKeys.put(JViewport.class, "Viewport.font");
        NO_BORDER_LABEL_RENDERER = new NoBorderLabelRenderer();
        NO_BORDER_BOOLEAN_RENDERER = new NoBorderBooleanRenderer();
        NO_BORDER_MONOSPACED_RENDERER = new NoBorderMonospacedRenderer();
        CENTERED_LABEL_RENDERER = new CenteredLabelRenderer();
        RIGHT_LABEL_RENDERER = new RightLabelRenderer();
    }

    public static interface Invocation<T> {
        public T run();
    }

    private static class NoClearSelectionModel
    extends DefaultListSelectionModel {
        public NoClearSelectionModel() {
            this.setSelectionMode(0);
            this.setSelectionInterval(0, 0);
        }

        @Override
        public void clearSelection() {
        }

        @Override
        public void removeSelectionInterval(int index0, int index1) {
        }
    }

    public static class NoBorderBooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public NoBorderBooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelected(value != null && (Boolean)value != false);
            this.setBorder(noFocusBorder);
            return this;
        }
    }

    public static class NoBorderMonospacedRenderer
    extends DefaultTableCellRenderer {
        private Font monospacedFont;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, rowIndex, columnIndex);
            Font tableFont = table.getFont();
            if (this.monospacedFont == null || this.monospacedFont.getSize() != tableFont.getSize()) {
                this.monospacedFont = new Font("Monospaced", 0, tableFont.getSize());
            }
            this.setFont(this.monospacedFont);
            this.setBorder(noFocusBorder);
            return this;
        }
    }

    public static class NoBorderListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return super.getListCellRendererComponent(list, value, index, isSelected, false);
        }
    }

    public static class NoBorderLabelRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setBorder(noFocusBorder);
            return this;
        }
    }

    public static class CenteredLabelRenderer
    extends DefaultTableCellRenderer {
        public CenteredLabelRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setBorder(noFocusBorder);
            return this;
        }
    }

    public static class RightLabelRenderer
    extends DefaultTableCellRenderer {
        public RightLabelRenderer() {
            this.setHorizontalAlignment(4);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setBorder(noFocusBorder);
            return this;
        }
    }

    public static class TableCellComboBoxRenderer
    extends JComboBox<String>
    implements TableCellRenderer {
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public TableCellComboBoxRenderer(String[] items) {
            super(items);
        }

        public TableCellComboBoxRenderer(ComboBoxModel<String> model) {
            super(model);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
            this.setSelectedItem(value);
            this.setBorder(noFocusBorder);
            return this;
        }
    }

    public static class TableMouseAdapter
    extends MouseAdapter {
        private final JTable table;
        private final TableCellClickedListener listener;
        private int lastRowIndex;
        private int lastColumnIndex;

        public TableMouseAdapter(JTable table, TableCellClickedListener listener) {
            this.table = table;
            this.listener = listener;
        }

        private void fireMouseClicked(int rowIndex, int columnIndex) {
            this.listener.mouseClicked(this.table.convertRowIndexToModel(rowIndex), this.table.convertColumnIndexToModel(columnIndex));
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            int rowIndex = this.table.rowAtPoint(evt.getPoint());
            int columnIndex = this.table.columnAtPoint(evt.getPoint());
            if (rowIndex >= 0 && columnIndex >= 0) {
                this.lastRowIndex = rowIndex;
                this.lastColumnIndex = columnIndex;
                this.fireMouseClicked(rowIndex, columnIndex);
            }
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            int rowIndex = this.table.rowAtPoint(evt.getPoint());
            int columnIndex = this.table.columnAtPoint(evt.getPoint());
            if (rowIndex >= 0 && columnIndex >= 0 && (rowIndex != this.lastRowIndex || columnIndex != this.lastColumnIndex)) {
                this.lastRowIndex = rowIndex;
                this.lastColumnIndex = columnIndex;
                this.fireMouseClicked(rowIndex, columnIndex);
            }
        }
    }
}

