/*
 * Decompiled with CFR 0.152.
 */
package nintaco.preferences;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nintaco.files.FileUtil;
import nintaco.gui.api.local.ProgramGamePrefs;
import nintaco.gui.debugger.DebuggerGamePrefs;
import nintaco.gui.debugger.logger.LoggerGamePrefs;
import nintaco.gui.dipswitches.DipSwitchesGamePrefs;
import nintaco.gui.hexeditor.preferences.HexEditorGamePrefs;
import nintaco.gui.mapmaker.MapMakerGamePrefs;
import nintaco.gui.ramwatch.RamWatchGamePrefs;
import nintaco.gui.spritesaver.SpriteSaverGamePrefs;
import nintaco.preferences.AppPrefs;
import nintaco.util.StreamUtil;
import nintaco.util.ThreadUtil;

public final class GamePrefs
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final List<Thread> threads = Collections.synchronizedList(new ArrayList());
    private static GamePrefs instance;
    private static String fileName;
    private transient int[] nonVolatilePrgRam;
    private transient int[] storageUnitRam;
    private transient int[] nonVolatileXRam;
    private HexEditorGamePrefs hexEditorGamePrefs;
    private MapMakerGamePrefs mapMakerGamePrefs;
    private SpriteSaverGamePrefs spriteSaverGamePrefs;
    private RamWatchGamePrefs ramWatchGamePrefs;
    private DebuggerGamePrefs debuggerGamePrefs;
    private LoggerGamePrefs loggerGamePrefs;
    private DipSwitchesGamePrefs dipSwitchesGamePrefs;
    private ProgramGamePrefs programGamePrefs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eraseNonVolatileRam() {
        Class<GamePrefs> clazz = GamePrefs.class;
        synchronized (GamePrefs.class) {
            this.nonVolatileXRam = null;
            this.storageUnitRam = null;
            this.nonVolatilePrgRam = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getNonVolatileXRam() {
        Class<GamePrefs> clazz = GamePrefs.class;
        synchronized (GamePrefs.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.nonVolatileXRam;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNonVolatileXRam(int[] nonVolatileXRam) {
        Class<GamePrefs> clazz = GamePrefs.class;
        synchronized (GamePrefs.class) {
            this.nonVolatileXRam = nonVolatileXRam;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getNonVolatilePrgRam() {
        Class<GamePrefs> clazz = GamePrefs.class;
        synchronized (GamePrefs.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.nonVolatilePrgRam;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNonVolatilePrgRam(int[] nonVolatilePrgRam) {
        Class<GamePrefs> clazz = GamePrefs.class;
        synchronized (GamePrefs.class) {
            this.nonVolatilePrgRam = nonVolatilePrgRam;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getStorageUnitRam() {
        Class<GamePrefs> clazz = GamePrefs.class;
        synchronized (GamePrefs.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.storageUnitRam;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStorageUnitRam(int[] storageUnitRam) {
        Class<GamePrefs> clazz = GamePrefs.class;
        synchronized (GamePrefs.class) {
            this.storageUnitRam = storageUnitRam;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggerGamePrefs getLoggerGamePrefs() {
        Class<GamePrefs> clazz = GamePrefs.class;
        synchronized (GamePrefs.class) {
            if (this.loggerGamePrefs == null) {
                this.loggerGamePrefs = new LoggerGamePrefs();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.loggerGamePrefs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebuggerGamePrefs getDebuggerGamePrefs() {
        Class<GamePrefs> clazz = GamePrefs.class;
        synchronized (GamePrefs.class) {
            if (this.debuggerGamePrefs == null) {
                this.debuggerGamePrefs = new DebuggerGamePrefs();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.debuggerGamePrefs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RamWatchGamePrefs getRamWatchGamePrefs() {
        Class<GamePrefs> clazz = GamePrefs.class;
        synchronized (GamePrefs.class) {
            if (this.ramWatchGamePrefs == null) {
                this.ramWatchGamePrefs = new RamWatchGamePrefs();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.ramWatchGamePrefs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpriteSaverGamePrefs getSpriteSaverGamePrefs() {
        Class<GamePrefs> clazz = GamePrefs.class;
        synchronized (GamePrefs.class) {
            if (this.spriteSaverGamePrefs == null) {
                this.spriteSaverGamePrefs = new SpriteSaverGamePrefs();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.spriteSaverGamePrefs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapMakerGamePrefs getMapMakerGamePrefs() {
        Class<GamePrefs> clazz = GamePrefs.class;
        synchronized (GamePrefs.class) {
            if (this.mapMakerGamePrefs == null) {
                this.mapMakerGamePrefs = new MapMakerGamePrefs();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.mapMakerGamePrefs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HexEditorGamePrefs getHexEditorGamePrefs() {
        Class<GamePrefs> clazz = GamePrefs.class;
        synchronized (GamePrefs.class) {
            if (this.hexEditorGamePrefs == null) {
                this.hexEditorGamePrefs = new HexEditorGamePrefs();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.hexEditorGamePrefs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DipSwitchesGamePrefs getDipSwitchesGamePrefs() {
        Class<GamePrefs> clazz = GamePrefs.class;
        synchronized (GamePrefs.class) {
            if (this.dipSwitchesGamePrefs == null) {
                this.dipSwitchesGamePrefs = new DipSwitchesGamePrefs();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.dipSwitchesGamePrefs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgramGamePrefs getProgramGamePrefs() {
        Class<GamePrefs> clazz = GamePrefs.class;
        synchronized (GamePrefs.class) {
            if (this.programGamePrefs == null) {
                this.programGamePrefs = new ProgramGamePrefs();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.programGamePrefs;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.nonVolatilePrgRam = StreamUtil.readSparseByteArray(in);
        this.storageUnitRam = StreamUtil.readSparseByteArray(in);
        this.nonVolatileXRam = StreamUtil.readSparseByteArray(in);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        StreamUtil.writeSparseByteArray(out, this.nonVolatilePrgRam);
        StreamUtil.writeSparseByteArray(out, this.storageUnitRam);
        StreamUtil.writeSparseByteArray(out, this.nonVolatileXRam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dispose() {
        ThreadUtil.joinAll(threads);
        Class<GamePrefs> clazz = GamePrefs.class;
        synchronized (GamePrefs.class) {
            fileName = null;
            instance = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(String entryFileName) {
        GamePrefs.dispose();
        Class<GamePrefs> clazz = GamePrefs.class;
        synchronized (GamePrefs.class) {
            fileName = FileUtil.createGamePreferencesFile(entryFileName);
            File file = new File(fileName);
            if (file.exists()) {
                try (ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(fileName)));){
                    instance = (GamePrefs)in.readObject();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save() {
        Class<GamePrefs> clazz = GamePrefs.class;
        synchronized (GamePrefs.class) {
            if (fileName == null || instance == null) {
                // ** MonitorExit[var2] (shouldn't be in output)
                return;
            }
            String name = fileName;
            GamePrefs prefs = instance;
            // ** MonitorExit[var2] (shouldn't be in output)
            Thread thread = new Thread(() -> {
                Class<GamePrefs> clazz = GamePrefs.class;
                synchronized (GamePrefs.class) {
                    FileUtil.mkdir(AppPrefs.getInstance().getPaths().getGamePreferencesDir());
                    try (ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(name)));){
                        out.writeObject(prefs);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    threads.remove(Thread.currentThread());
                    return;
                }
            }, "GamePrefs Save Thread");
            List<Thread> list = threads;
            synchronized (list) {
                thread.start();
                threads.add(thread);
            }
            return;
        }
    }

    public static synchronized GamePrefs getInstance() {
        if (instance == null) {
            instance = new GamePrefs();
        }
        return instance;
    }

    private GamePrefs() {
    }
}

