/*
 * Decompiled with CFR 0.152.
 */
package nintaco.preferences;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nintaco.files.FileUtil;
import nintaco.gui.api.server.ProgramServerPrefs;
import nintaco.gui.archive.ArchivePrefs;
import nintaco.gui.cheats.CheatPrefs;
import nintaco.gui.debugger.DebuggerAppPrefs;
import nintaco.gui.debugger.logger.LoggerAppPrefs;
import nintaco.gui.dipswitches.DipSwitchesAppPrefs;
import nintaco.gui.exportmedia.preferences.ExportMediaFilePrefs;
import nintaco.gui.familybasic.FamilyBasicPrefs;
import nintaco.gui.fds.FamicomDiskSystemPrefs;
import nintaco.gui.hexeditor.preferences.HexEditorAppPrefs;
import nintaco.gui.historyeditor.preferences.HistoryEditorPrefs;
import nintaco.gui.image.preferences.HistoryPrefs;
import nintaco.gui.image.preferences.Paths;
import nintaco.gui.image.preferences.View;
import nintaco.gui.ips.IpsPatchPrefs;
import nintaco.gui.mapmaker.MapMakerAppPrefs;
import nintaco.gui.nametables.NametablesPrefs;
import nintaco.gui.netplay.client.NetplayClientPrefs;
import nintaco.gui.netplay.server.NetplayServerPrefs;
import nintaco.gui.nsf.NsfPrefs;
import nintaco.gui.oam.OamDataPrefs;
import nintaco.gui.overscan.OverscanPrefs;
import nintaco.gui.patterntables.PatternTablesPrefs;
import nintaco.gui.ramsearch.RamSearchPrefs;
import nintaco.gui.sound.SoundPrefs;
import nintaco.gui.sound.volumemixer.VolumeMixerPrefs;
import nintaco.gui.spritesaver.SpriteSaverAppPrefs;
import nintaco.gui.userinterface.UserInterfacePrefs;
import nintaco.input.Inputs;
import nintaco.palettes.Palettes;
import nintaco.util.ThreadUtil;

public final class AppPrefs
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final File PREFERENCES_FILE = new File(FileUtil.getWorkingDirectory("nintaco.preferences"));
    private static AppPrefs instance;
    private static final List<Thread> threads;
    private Paths paths;
    private View view;
    private Inputs inputs;
    private Palettes palettes;
    private HexEditorAppPrefs hexEditorPrefs;
    private CheatPrefs cheatPrefs;
    private PatternTablesPrefs patternTablesPrefs;
    private NametablesPrefs nametablesPrefs;
    private MapMakerAppPrefs mapMakerAppPrefs;
    private SpriteSaverAppPrefs spriteSaverAppPrefs;
    private RamSearchPrefs ramSearchPrefs;
    private LoggerAppPrefs loggerAppPrefs;
    private HistoryEditorPrefs historyEditorPrefs;
    private ProgramServerPrefs programSreverPrefs;
    private NetplayServerPrefs netplayServerPrefs;
    private NetplayClientPrefs netplayClientPrefs;
    private FamicomDiskSystemPrefs famicomDiskSystemPrefs;
    private DipSwitchesAppPrefs dipSwitchesAppPrefs;
    private SoundPrefs soundPrefs;
    private VolumeMixerPrefs volumeMixerPrefs;
    private ExportMediaFilePrefs exportMediaFilePrefs;
    private ExportMediaFilePrefs screenshotPrefs;
    private HistoryPrefs historyPrefs;
    private OverscanPrefs overscanPrefs;
    private ArchivePrefs archivePrefs;
    private UserInterfacePrefs userInterfacePrefs;
    private IpsPatchPrefs applyIpsPatchPrefs;
    private IpsPatchPrefs createIpsPatchPrefs;
    private OamDataPrefs oamDataPrefs;
    private NsfPrefs nsfPrefs;
    private FamilyBasicPrefs familyBasicPrefs;
    private DebuggerAppPrefs debuggerAppPrefs;

    public synchronized DebuggerAppPrefs getDebuggerAppPrefs() {
        if (this.debuggerAppPrefs == null) {
            this.debuggerAppPrefs = new DebuggerAppPrefs();
        }
        return this.debuggerAppPrefs;
    }

    public synchronized FamilyBasicPrefs getFamilyBasicPrefs() {
        if (this.familyBasicPrefs == null) {
            this.familyBasicPrefs = new FamilyBasicPrefs();
        }
        return this.familyBasicPrefs;
    }

    public synchronized NsfPrefs getNsfPrefs() {
        if (this.nsfPrefs == null) {
            this.nsfPrefs = new NsfPrefs();
        }
        return this.nsfPrefs;
    }

    public synchronized OamDataPrefs getOamDataPrefs() {
        if (this.oamDataPrefs == null) {
            this.oamDataPrefs = new OamDataPrefs();
        }
        return this.oamDataPrefs;
    }

    public synchronized IpsPatchPrefs getApplyIpsPatchPrefs() {
        if (this.applyIpsPatchPrefs == null) {
            this.applyIpsPatchPrefs = new IpsPatchPrefs();
        }
        return this.applyIpsPatchPrefs;
    }

    public synchronized IpsPatchPrefs getCreateIpsPatchPrefs() {
        if (this.createIpsPatchPrefs == null) {
            this.createIpsPatchPrefs = new IpsPatchPrefs();
        }
        return this.createIpsPatchPrefs;
    }

    public synchronized UserInterfacePrefs getUserInterfacePrefs() {
        if (this.userInterfacePrefs == null) {
            this.userInterfacePrefs = new UserInterfacePrefs();
        }
        return this.userInterfacePrefs;
    }

    public synchronized ArchivePrefs getArchivePrefs() {
        if (this.archivePrefs == null) {
            this.archivePrefs = new ArchivePrefs();
        }
        return this.archivePrefs;
    }

    public synchronized OverscanPrefs getOverscanPrefs() {
        if (this.overscanPrefs == null) {
            this.overscanPrefs = new OverscanPrefs();
        }
        return this.overscanPrefs;
    }

    public synchronized Palettes getPalettes() {
        if (this.palettes == null) {
            this.palettes = new Palettes();
        }
        return this.palettes;
    }

    public synchronized HistoryPrefs getHistoryPrefs() {
        if (this.historyPrefs == null) {
            this.historyPrefs = new HistoryPrefs();
        }
        return this.historyPrefs;
    }

    public synchronized ExportMediaFilePrefs getScreenshotPrefs() {
        if (this.screenshotPrefs == null) {
            this.screenshotPrefs = new ExportMediaFilePrefs();
            this.screenshotPrefs.setFileType(3);
        }
        return this.screenshotPrefs;
    }

    public synchronized ExportMediaFilePrefs getExportMediaFilePrefs() {
        if (this.exportMediaFilePrefs == null) {
            this.exportMediaFilePrefs = new ExportMediaFilePrefs();
        }
        return this.exportMediaFilePrefs;
    }

    public synchronized VolumeMixerPrefs getVolumeMixerPrefs() {
        if (this.volumeMixerPrefs == null) {
            this.volumeMixerPrefs = new VolumeMixerPrefs();
        }
        return this.volumeMixerPrefs;
    }

    public synchronized SoundPrefs getSoundPrefs() {
        if (this.soundPrefs == null) {
            this.soundPrefs = new SoundPrefs();
        }
        return this.soundPrefs;
    }

    public synchronized DipSwitchesAppPrefs getDipSwitchesAppPrefs() {
        if (this.dipSwitchesAppPrefs == null) {
            this.dipSwitchesAppPrefs = new DipSwitchesAppPrefs();
        }
        return this.dipSwitchesAppPrefs;
    }

    public synchronized FamicomDiskSystemPrefs getFamicomDiskSystemPrefs() {
        if (this.famicomDiskSystemPrefs == null) {
            this.famicomDiskSystemPrefs = new FamicomDiskSystemPrefs();
        }
        return this.famicomDiskSystemPrefs;
    }

    public synchronized ProgramServerPrefs getProgramServerPrefs() {
        if (this.programSreverPrefs == null) {
            this.programSreverPrefs = new ProgramServerPrefs();
        }
        return this.programSreverPrefs;
    }

    public synchronized NetplayServerPrefs getNetplayServerPrefs() {
        if (this.netplayServerPrefs == null) {
            this.netplayServerPrefs = new NetplayServerPrefs();
        }
        return this.netplayServerPrefs;
    }

    public synchronized NetplayClientPrefs getNetplayClientPrefs() {
        if (this.netplayClientPrefs == null) {
            this.netplayClientPrefs = new NetplayClientPrefs();
        }
        return this.netplayClientPrefs;
    }

    public synchronized HistoryEditorPrefs getHistoryEditorPrefs() {
        if (this.historyEditorPrefs == null) {
            this.historyEditorPrefs = new HistoryEditorPrefs();
        }
        return this.historyEditorPrefs;
    }

    public synchronized LoggerAppPrefs getLoggerAppPrefs() {
        if (this.loggerAppPrefs == null) {
            this.loggerAppPrefs = new LoggerAppPrefs();
        }
        return this.loggerAppPrefs;
    }

    public synchronized RamSearchPrefs getRamSearchAppPrefs() {
        if (this.ramSearchPrefs == null) {
            this.ramSearchPrefs = new RamSearchPrefs();
        }
        return this.ramSearchPrefs;
    }

    public synchronized SpriteSaverAppPrefs getSpriteSaverAppPrefs() {
        if (this.spriteSaverAppPrefs == null) {
            this.spriteSaverAppPrefs = new SpriteSaverAppPrefs();
        }
        return this.spriteSaverAppPrefs;
    }

    public synchronized MapMakerAppPrefs getMapMakerAppPrefs() {
        if (this.mapMakerAppPrefs == null) {
            this.mapMakerAppPrefs = new MapMakerAppPrefs();
        }
        return this.mapMakerAppPrefs;
    }

    public synchronized NametablesPrefs getNametablesPrefs() {
        if (this.nametablesPrefs == null) {
            this.nametablesPrefs = new NametablesPrefs();
        }
        return this.nametablesPrefs;
    }

    public synchronized PatternTablesPrefs getPatternTablesPrefs() {
        if (this.patternTablesPrefs == null) {
            this.patternTablesPrefs = new PatternTablesPrefs();
        }
        return this.patternTablesPrefs;
    }

    public synchronized CheatPrefs getCheatPrefs() {
        if (this.cheatPrefs == null) {
            this.cheatPrefs = new CheatPrefs();
        }
        return this.cheatPrefs;
    }

    public synchronized HexEditorAppPrefs getHexEditorPrefs() {
        if (this.hexEditorPrefs == null) {
            this.hexEditorPrefs = new HexEditorAppPrefs();
        }
        return this.hexEditorPrefs;
    }

    public synchronized Paths getPaths() {
        if (this.paths == null) {
            this.paths = new Paths();
        }
        return this.paths;
    }

    public synchronized View getView() {
        if (this.view == null) {
            this.view = new View();
        }
        return this.view;
    }

    public synchronized Inputs getInputs() {
        if (this.inputs == null) {
            this.inputs = new Inputs();
        }
        return this.inputs;
    }

    public static synchronized AppPrefs getInstance() {
        return instance;
    }

    public static void flush() {
        ThreadUtil.joinAll(threads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dispose() {
        ThreadUtil.joinAll(threads);
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            instance = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() {
        AppPrefs.dispose();
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            try (ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(PREFERENCES_FILE)));){
                instance = (AppPrefs)in.readObject();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (instance == null) {
                instance = new AppPrefs();
            }
            instance.getPaths().init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save() {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            if (instance == null) {
                // ** MonitorExit[var1] (shouldn't be in output)
                return;
            }
            AppPrefs prefs = instance;
            // ** MonitorExit[var1] (shouldn't be in output)
            Thread thread = new Thread(() -> {
                Class<AppPrefs> clazz = AppPrefs.class;
                synchronized (AppPrefs.class) {
                    try (ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(PREFERENCES_FILE)));){
                        out.writeObject(prefs);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    threads.remove(Thread.currentThread());
                    return;
                }
            }, "AppPrefs Save Thread");
            List<Thread> list = threads;
            synchronized (list) {
                thread.start();
                threads.add(thread);
            }
            return;
        }
    }

    private AppPrefs() {
    }

    static {
        threads = Collections.synchronizedList(new ArrayList());
    }
}

