/*
 * Decompiled with CFR 0.152.
 */
package nintaco.netplay.server;

import java.io.Serializable;
import java.net.ServerSocket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nintaco.App;
import nintaco.MachineRunner;
import nintaco.files.IFile;
import nintaco.gui.image.QuickSaveListener;
import nintaco.gui.image.QuickSaveStateInfo;
import nintaco.gui.netplay.server.NetplayServerFrame;
import nintaco.gui.netplay.server.NetplayServerPrefs;
import nintaco.input.OtherInput;
import nintaco.input.Ports;
import nintaco.movie.Movie;
import nintaco.netplay.protocol.ControllerInput;
import nintaco.netplay.protocol.FileResponse;
import nintaco.netplay.server.FileRequest;
import nintaco.netplay.server.RemoteClient;
import nintaco.preferences.AppPrefs;
import nintaco.util.BitUtil;
import nintaco.util.CollectionsUtil;
import nintaco.util.StreamUtil;
import nintaco.util.ThreadUtil;

public class NetplayServer {
    public static final int BAOS_SIZE = 262144;
    private static final String NAME = "[Server]";
    private final List<RemoteClient> remoteClients = Collections.synchronizedList(new ArrayList());
    private final List<FileRequest> fileRequests = Collections.synchronizedList(new ArrayList());
    private final RemoteClient[] activePlayers = new RemoteClient[4];
    private final Object FileRequestIDSequenceMonitor = new Object();
    private final QuickSaveListener quickSaveListener = this::onQuickSaveChanged;
    private NetplayServerPrefs prefs;
    private Thread mainThread;
    private ServerSocket serverSocket;
    private boolean fourPlayers;
    private boolean[] localPlayers;
    private boolean allowRewindTime;
    private boolean allowHighSpeed;
    private boolean wasTrackingHistory;
    private int fileRequestIDSequence;
    private volatile boolean running;
    private volatile RemoteClient[] allPlayers;
    private volatile String[] quickSaveStateMenuNames;

    public void start() {
        if (this.mainThread != null) {
            this.stop();
        }
        this.mainThread = new Thread(this::run, "Netplay Server Thread");
        this.mainThread.start();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setMachineRunner(MachineRunner machineRunner) {
        if (this.running) {
            if (machineRunner != null) {
                this.addActivity("%s File loaded.", NAME);
                machineRunner.setServer(this);
            } else {
                this.addActivity("%s File closed.", NAME);
            }
            this.postFileAndSaveState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pause(RemoteClient remoteClient, int fileRequestID) {
        List<FileRequest> list = this.fileRequests;
        synchronized (list) {
            for (FileRequest fileRequest : this.fileRequests) {
                if (fileRequest.getRemoteClient() != remoteClient || fileRequest.getFileRequestID() != fileRequestID) continue;
                return;
            }
            if (this.fileRequests.isEmpty()) {
                App.setNoStepPause(true);
            }
            this.fileRequests.add(new FileRequest(remoteClient, fileRequestID));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean resume(RemoteClient remoteClient, int fileRequestID) {
        boolean allRemoved = true;
        List<FileRequest> list = this.fileRequests;
        synchronized (list) {
            for (int i = this.fileRequests.size() - 1; i >= 0; --i) {
                FileRequest fileRequest = this.fileRequests.get(i);
                if (fileRequest.getRemoteClient() != remoteClient) continue;
                if (fileRequest.getFileRequestID() == fileRequestID) {
                    this.fileRequests.remove(i);
                    continue;
                }
                allRemoved = false;
            }
            if (this.fileRequests.isEmpty()) {
                App.setNoStepPause(false);
            }
        }
        return allRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resume(RemoteClient remoteClient) {
        List<FileRequest> list = this.fileRequests;
        synchronized (list) {
            for (int i = this.fileRequests.size() - 1; i >= 0; --i) {
                FileRequest fileRequest = this.fileRequests.get(i);
                if (fileRequest.getRemoteClient() != remoteClient) continue;
                this.fileRequests.remove(i);
            }
            if (this.fileRequests.isEmpty()) {
                App.setNoStepPause(false);
            }
        }
    }

    public int mergeHighSpeed(int highSpeedValue) {
        if (this.allowHighSpeed) {
            for (int i = 3; i >= 0; --i) {
                if (this.localPlayers[i]) continue;
                highSpeedValue &= ~(1 << i);
                RemoteClient remoteClient = this.activePlayers[i];
                if (remoteClient == null) continue;
                int v = remoteClient.readHighSpeedValue();
                highSpeedValue |= v & 1 << i;
            }
        } else {
            for (int i = 3; i >= 0; --i) {
                if (this.localPlayers[i]) continue;
                highSpeedValue &= ~(1 << i);
            }
        }
        return highSpeedValue;
    }

    public int mergeRewindTime(int rewindTimeValue) {
        if (this.allowRewindTime) {
            for (int i = 3; i >= 0; --i) {
                if (this.localPlayers[i]) continue;
                rewindTimeValue &= ~(33 << i);
                RemoteClient remoteClient = this.activePlayers[i];
                if (remoteClient == null) continue;
                int v = remoteClient.readRewindTimeValue();
                rewindTimeValue |= v & 1 << i | (v & 0x10) << i + 1;
            }
        } else {
            for (int i = 3; i >= 0; --i) {
                if (this.localPlayers[i]) continue;
                rewindTimeValue &= ~(33 << i);
            }
        }
        return rewindTimeValue;
    }

    public void mergeControllerInput(ControllerInput controllerInput) {
        int mergedInput = 0;
        for (int i = 3; i >= 0; --i) {
            if (this.localPlayers[i]) {
                mergedInput |= controllerInput.input & 255 << (i << 3);
                continue;
            }
            RemoteClient remoteClient = this.activePlayers[i];
            if (remoteClient == null) continue;
            ControllerInput in = remoteClient.readControllerInput();
            mergedInput |= in.input & 255 << (i << 3);
            if (in.otherInputs == null) continue;
            controllerInput.otherInputs = CollectionsUtil.concat(OtherInput.class, controllerInput.otherInputs, in.otherInputs);
            in.otherInputs = null;
        }
        controllerInput.input = mergedInput;
    }

    public void postSaveState(MachineRunner machineRunner) {
        if (this.running && machineRunner != null) {
            machineRunner.setServer(this);
            byte[] saveState = StreamUtil.toByteArrayOutputStream(machineRunner.getMachine()).toByteArray();
            RemoteClient[] clients = this.allPlayers;
            for (int i = clients.length - 1; i >= 0; --i) {
                RemoteClient remoteClient = clients[i];
                if (remoteClient == null) continue;
                remoteClient.post(12, saveState);
            }
        }
    }

    private void postFileAndSaveState() {
        if (this.running) {
            IFile file = App.getFile();
            MachineRunner machineRunner = App.getMachineRunner();
            byte[] fileResponse = null;
            RemoteClient[] clients = this.allPlayers;
            if (file != null && machineRunner != null) {
                Ports ports = AppPrefs.getInstance().getInputs().getPorts();
                Movie movie = machineRunner.getMovie();
                int fileRequestID = this.createFileRequestID();
                for (int i = clients.length - 1; i >= 0; --i) {
                    RemoteClient remoteClient = clients[i];
                    if (remoteClient == null) continue;
                    remoteClient.pause(fileRequestID);
                }
                fileResponse = StreamUtil.toByteArrayOutputStream(new FileResponse(fileRequestID, file, machineRunner.getMachine(), movie != null ? movie.getFrameIndex() : 0, machineRunner.isForwardTime(), machineRunner.getCurrentMovieBlock(), machineRunner.getMovieBlock(), ports.getConsoleType(), ports.isMultitap(), this.quickSaveStateMenuNames, App.getImageFrame().getFileInfo())).toByteArray();
            }
            for (int i = clients.length - 1; i >= 0; --i) {
                RemoteClient remoteClient = clients[i];
                if (remoteClient == null) continue;
                remoteClient.postFileAndSaveState(fileResponse, false);
            }
        }
    }

    public void writeControllerInput(ControllerInput controllerInput) {
        if (this.running) {
            this.post(11, controllerInput.input, (Serializable)controllerInput.otherInputs);
        }
    }

    public void post(int messageType, String str) {
        if (this.running) {
            this.post(messageType, str == null ? null : str.getBytes(StandardCharsets.ISO_8859_1));
        }
    }

    public void post(int messageType, Serializable serializable) {
        if (this.running) {
            this.post(messageType, serializable == null ? null : StreamUtil.toByteArrayOutputStream(serializable).toByteArray());
        }
    }

    public void post(int messageType, int value, Serializable serializable) {
        if (this.running) {
            this.post(messageType, value, serializable == null ? null : StreamUtil.toByteArrayOutputStream(serializable).toByteArray());
        }
    }

    public void post(int messageType, int value, byte[] data) {
        if (this.running) {
            RemoteClient[] clients = this.allPlayers;
            for (int i = clients.length - 1; i >= 0; --i) {
                RemoteClient remoteClient = clients[i];
                if (remoteClient == null) continue;
                remoteClient.post(messageType, value, data);
            }
        }
    }

    public void post(int messageType, byte[] data) {
        if (this.running) {
            RemoteClient[] clients = this.allPlayers;
            for (int i = clients.length - 1; i >= 0; --i) {
                RemoteClient remoteClient = clients[i];
                if (remoteClient == null) continue;
                remoteClient.post(messageType, data);
            }
        }
    }

    public void post(int messageType, int value) {
        if (this.running) {
            RemoteClient[] clients = this.allPlayers;
            for (int i = clients.length - 1; i >= 0; --i) {
                RemoteClient remoteClient = clients[i];
                if (remoteClient == null) continue;
                remoteClient.post(messageType, value);
            }
        }
    }

    public void post(int type) {
        if (this.running) {
            RemoteClient[] clients = this.allPlayers;
            for (int i = clients.length - 1; i >= 0; --i) {
                RemoteClient remoteClient = clients[i];
                if (remoteClient == null) continue;
                remoteClient.post(type);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int createFileRequestID() {
        Object object = this.FileRequestIDSequenceMonitor;
        synchronized (object) {
            return this.fileRequestIDSequence++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int requestPlayer(RemoteClient remoteClient, int player) {
        List<RemoteClient> list = this.remoteClients;
        synchronized (list) {
            int i;
            this.removePlayer(remoteClient);
            int bits = this.prefs.isAllowSpectators() ? 1 : 0;
            for (i = this.activePlayers.length - 1; i >= 0; --i) {
                bits = bits << 1 | (!this.localPlayers[i] && this.activePlayers[i] == null && (i < 2 || this.fourPlayers) ? 1 : 0);
            }
            if (!remoteClient.isRunning()) {
                return bits;
            }
            if (BitUtil.getBitBool(bits, player)) {
                block9: {
                    if (player < 4) {
                        this.activePlayers[player] = remoteClient;
                    }
                    for (i = this.allPlayers.length - 1; i >= 0; --i) {
                        if (remoteClient != this.allPlayers[i]) {
                            continue;
                        }
                        break block9;
                    }
                    RemoteClient[] clients = new RemoteClient[this.allPlayers.length + 1];
                    System.arraycopy(this.allPlayers, 0, clients, 0, this.allPlayers.length);
                    clients[this.allPlayers.length] = remoteClient;
                    this.allPlayers = clients;
                }
                return 255;
            }
            return bits;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePlayer(RemoteClient remoteClient) {
        this.resume(remoteClient);
        List<RemoteClient> list = this.remoteClients;
        synchronized (list) {
            int i;
            for (i = this.activePlayers.length - 1; i >= 0; --i) {
                if (this.activePlayers[i] != remoteClient) continue;
                this.activePlayers[i] = null;
            }
            for (i = this.allPlayers.length - 1; i >= 0; --i) {
                if (this.allPlayers[i] != remoteClient) continue;
                RemoteClient[] clients = new RemoteClient[this.allPlayers.length - 1];
                int k = clients.length - 1;
                for (int j = this.allPlayers.length - 1; j >= 0; --j) {
                    if (j == i) continue;
                    clients[k--] = this.allPlayers[j];
                }
                this.allPlayers = clients;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRemoteClient(RemoteClient remoteClient) {
        List<RemoteClient> list = this.remoteClients;
        synchronized (list) {
            this.removePlayer(remoteClient);
            this.remoteClients.remove(remoteClient);
            this.remoteClients.notifyAll();
        }
    }

    void addActivity(String activity, Object ... params) {
        NetplayServerFrame serverFrame = App.getNetworkServerFrame();
        if (serverFrame != null) {
            serverFrame.addActivity(activity, params);
        }
    }

    private void setServerStatus(boolean serverUp) {
        NetplayServerFrame serverFrame = App.getNetworkServerFrame();
        if (serverFrame != null) {
            serverFrame.setServerStatus(serverUp);
        }
    }

    String[] getQuickSaveStateMenuNames() {
        return this.quickSaveStateMenuNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        MachineRunner machineRunner;
        AppPrefs appPrefs = AppPrefs.getInstance();
        Ports ports = appPrefs.getInputs().getPorts();
        this.wasTrackingHistory = appPrefs.getHistoryPrefs().isTrackHistory();
        if (!this.wasTrackingHistory) {
            appPrefs.getHistoryPrefs().setTrackHistory(true);
            App.setTrackHistory(true);
        }
        this.prefs = appPrefs.getNetplayServerPrefs();
        this.allowRewindTime = this.prefs.isAllowRewindTime();
        this.allowHighSpeed = this.prefs.isAllowHighSpeed();
        this.localPlayers = this.prefs.getLocalPlayers();
        this.fileRequestIDSequence = 0;
        this.fourPlayers = ports.isMultitap() || ports.getConsoleType() == 2;
        for (int i = this.activePlayers.length - 1; i >= 0; --i) {
            this.activePlayers[i] = null;
        }
        this.allPlayers = new RemoteClient[0];
        this.remoteClients.clear();
        this.fileRequests.clear();
        try {
            this.serverSocket = new ServerSocket(this.prefs.getPort(), 50, this.prefs.getLocalIPAddress());
        }
        catch (Throwable t) {
            this.addActivity("%s Failed to start: %s", NAME, t.getMessage());
            this.setServerStatus(false);
            return;
        }
        this.addActivity("%s Started.", NAME);
        this.addActivity("%s Listening for clients on port %d.", NAME, this.prefs.getPort());
        this.setServerStatus(true);
        try {
            this.running = true;
            machineRunner = App.getMachineRunner();
            if (machineRunner != null) {
                machineRunner.setServer(this);
            }
            App.getImageFrame().addQuickSaveListener(this.quickSaveListener);
            while (this.running) {
                RemoteClient remoteClient = new RemoteClient(this, this.serverSocket.accept(), this.prefs);
                this.remoteClients.add(remoteClient);
                new Thread(remoteClient).start();
            }
        }
        catch (Throwable t) {
            this.stop();
        }
        finally {
            App.getImageFrame().removeQuickSaveListener(this.quickSaveListener);
            this.quickSaveStateMenuNames = null;
        }
        List<RemoteClient> t = this.remoteClients;
        synchronized (t) {
            while (!this.remoteClients.isEmpty()) {
                ThreadUtil.threadWait(this.remoteClients);
            }
        }
        machineRunner = App.getMachineRunner();
        if (machineRunner != null) {
            machineRunner.clearServer();
        }
        if (!this.wasTrackingHistory) {
            appPrefs.getHistoryPrefs().setTrackHistory(false);
            App.setTrackHistory(false);
        }
        this.addActivity("%s Stopped.", NAME);
        this.setServerStatus(false);
    }

    private void onQuickSaveChanged(List<QuickSaveStateInfo> quickSaveStateInfos) {
        if (this.running) {
            String[] menuNames = new String[quickSaveStateInfos.size()];
            for (int i = quickSaveStateInfos.size() - 1; i >= 0; --i) {
                menuNames[i] = quickSaveStateInfos.get(i).getLoadMenuItem().getText();
            }
            this.quickSaveStateMenuNames = menuNames;
            this.post(17, (Serializable)this.quickSaveStateMenuNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.running = false;
        List<RemoteClient> list = this.remoteClients;
        synchronized (list) {
            for (RemoteClient remoteClient : this.remoteClients) {
                remoteClient.dispose();
            }
        }
        try {
            ServerSocket s = this.serverSocket;
            if (s != null) {
                this.serverSocket = null;
                s.close();
            }
        }
        catch (Throwable s) {
            // empty catch block
        }
        Thread t = this.mainThread;
        if (t != null) {
            this.mainThread = null;
            ThreadUtil.interrupt(t);
            ThreadUtil.join(t);
        }
    }
}

