/*
 * Decompiled with CFR 0.152.
 */
package nintaco.netplay.queue;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import nintaco.netplay.queue.ElementDataType;
import nintaco.netplay.queue.QueueElement;
import nintaco.util.StreamUtil;
import nintaco.util.ThreadUtil;

public class RingQueue {
    private static final int SIZE = 256;
    private static final int MASK = 255;
    private final Object monitor = new Object();
    private final QueueElement[] elements = new QueueElement[256];
    private volatile int head;
    private volatile boolean running;

    public RingQueue() {
        for (int i = this.elements.length - 1; i >= 0; --i) {
            this.elements[i] = new QueueElement();
        }
    }

    public void produce(int messageType) {
        this.produce(messageType, ElementDataType.NONE, 0, null);
    }

    public void produce(int messageType, int value) {
        this.produce(messageType, ElementDataType.INTEGER, value, null);
    }

    public void produce(int messageType, Serializable serializable) {
        this.produce(messageType, ElementDataType.BYTES, 0, serializable == null ? null : StreamUtil.toByteArrayOutputStream(serializable).toByteArray());
    }

    public void produce(int messageType, int value, Serializable serializable) {
        this.produce(messageType, ElementDataType.ALL, value, serializable == null ? null : StreamUtil.toByteArrayOutputStream(serializable).toByteArray());
    }

    public void produce(int messageType, ByteArrayOutputStream data) {
        this.produce(messageType, ElementDataType.BYTES, 0, data == null ? null : data.toByteArray());
    }

    public void produce(int messageType, int value, ByteArrayOutputStream data) {
        this.produce(messageType, ElementDataType.ALL, value, data == null ? null : data.toByteArray());
    }

    public void produce(int messageType, byte[] data) {
        this.produce(messageType, ElementDataType.BYTES, 0, data);
    }

    public void produce(int messageType, int value, byte[] data) {
        this.produce(messageType, ElementDataType.ALL, value, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void produce(int messageType, ElementDataType dataType, int value, byte[] data) {
        Object object = this.monitor;
        synchronized (object) {
            if (!this.running) {
                return;
            }
            QueueElement element = this.elements[this.head & 0xFF];
            element.messageType = messageType;
            element.dataType = dataType;
            element.value = value;
            element.data = data;
            ++this.head;
            this.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.monitor;
        synchronized (object) {
            this.head = 0;
            this.running = true;
            this.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.monitor;
        synchronized (object) {
            this.running = false;
            this.monitor.notifyAll();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getHead() {
        return this.head;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean consume(int tail, QueueElement element) {
        if (!this.running) {
            return false;
        }
        if (tail >= this.head) {
            Object object = this.monitor;
            synchronized (object) {
                while (this.running && tail == this.head) {
                    ThreadUtil.threadWait(this.monitor);
                }
            }
        }
        if (!this.running || this.head - tail >= 256) {
            return false;
        }
        QueueElement e = this.elements[tail & 0xFF];
        element.data = e.data;
        element.dataType = e.dataType;
        element.messageType = e.messageType;
        element.value = e.value;
        return true;
    }
}

