/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.waixing;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class Mapper249
extends MMC3 {
    private boolean scramble;

    public Mapper249(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    protected void setPrgBank(int bank, int value) {
        if (this.scramble) {
            if (value < 32) {
                value = value & 1 | value >> 3 & 2 | value >> 1 & 4 | value << 2 & 0x18;
            } else {
                value -= 32;
                value = value & 3 | value >> 1 & 4 | value >> 4 & 8 | value >> 2 & 0x10 | value << 3 & 0x20 | value << 2 & 0xC0;
            }
        }
        super.setPrgBank(bank, value);
    }

    @Override
    protected void setChrBank(int bank, int value) {
        if (this.scramble) {
            value = value & 3 | value >> 1 & 4 | value >> 4 & 8 | value >> 2 & 0x10 | value << 3 & 0x20 | value << 2 & 0xC0;
        }
        super.setChrBank(bank, value);
    }

    @Override
    public void writeMemory(int address, int value) {
        if (address == 20480) {
            this.scramble = BitUtil.getBitBool(value, 1);
            this.updateBanks();
        }
        super.writeMemory(address, value);
    }
}

