/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.waixing;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class Mapper164
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int prgBank;

    public Mapper164(CartFile cartFile) {
        super(cartFile, 2, 1, 20480, 32768);
    }

    @Override
    public void init() {
        this.prgBank = 15;
        this.setPrgBank(this.prgBank);
        this.setChrBank(0);
    }

    @Override
    public void resetting() {
        this.init();
    }

    @Override
    public int readMemory(int address) {
        if ((address & 0xF000) == 20480) {
            return 255;
        }
        return super.readMemory(address);
    }

    @Override
    protected void writeRegister(int address, int value) {
        switch (address & 0x7300) {
            case 20480: {
                this.prgBank = this.prgBank & 0xF0 | value & 0xF;
                this.setPrgBank(this.prgBank);
                break;
            }
            case 20736: {
                this.prgBank = this.prgBank & 0xF | (value & 0xF) << 4;
                this.setPrgBank(this.prgBank);
            }
        }
    }
}

