/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.unl.dripgame;

import nintaco.mappers.Audio;
import nintaco.mappers.unif.unl.dripgame.DripGameAudioChannel;

public class DripGameAudio
extends Audio {
    private static final long serialVersionUID = 0L;
    private final DripGameAudioChannel[] channels = new DripGameAudioChannel[2];

    public DripGameAudio() {
        for (int i = this.channels.length - 1; i >= 0; --i) {
            this.channels[i] = new DripGameAudioChannel();
        }
    }

    @Override
    public void reset() {
        this.channels[0].reset();
        this.channels[1].reset();
    }

    public int getStatus(int channel) {
        return this.channels[channel].getStatus();
    }

    @Override
    public boolean writeRegister(int address, int value) {
        switch (address & 0xF00F) {
            case 32768: {
                this.channels[0].silence();
                return true;
            }
            case 32769: {
                this.channels[0].enqueue(value);
                return true;
            }
            case 32770: {
                this.channels[0].setLowPeriod(value);
                return true;
            }
            case 32771: {
                this.channels[0].setHighPeriod(value);
                return true;
            }
            case 32772: {
                this.channels[1].silence();
                return true;
            }
            case 32773: {
                this.channels[1].enqueue(value);
                return true;
            }
            case 32774: {
                this.channels[1].setLowPeriod(value);
                return true;
            }
            case 32775: {
                this.channels[1].setHighPeriod(value);
                return true;
            }
        }
        return false;
    }

    @Override
    public void update() {
        this.channels[0].update();
        this.channels[1].update();
    }

    @Override
    public int getAudioMixerScale() {
        return 0;
    }

    @Override
    public float getAudioSample() {
        return 8.56666f * (float)(this.channels[0].getSample() + this.channels[1].getSample());
    }
}

