/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.unl;

import nintaco.files.CartFile;
import nintaco.mappers.pirate.Mapper083;
import nintaco.util.BitUtil;

public class YOKO
extends Mapper083 {
    private static final long serialVersionUID = 0L;

    public YOKO(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void init() {
        this.resetBit = 3;
        super.init();
    }

    @Override
    public void resetting() {
        this.resetBit = this.resetBit + 1 & 3;
        this.mode = 0;
        this.bank = 0;
        this.updateBanks();
    }

    @Override
    protected void updateBanks() {
        this.setNametableMirroring(this.mode & 1);
        this.setChrBanks(0, 2, this.regs[3] << 1);
        this.setChrBanks(2, 2, this.regs[4] << 1);
        this.setChrBanks(4, 2, this.regs[5] << 1);
        this.setChrBanks(6, 2, this.regs[6] << 1);
        if (BitUtil.getBitBool(this.mode, 4)) {
            int base = (this.bank & 8) << 1;
            this.setPrgBank(4, base | this.regs[0] & 0xF);
            this.setPrgBank(5, base | this.regs[1] & 0xF);
            this.setPrgBank(6, base | this.regs[2] & 0xF);
            this.setPrgBank(7, base | 0xF);
        } else if (BitUtil.getBitBool(this.mode, 3)) {
            this.setPrgBanks(4, 4, (this.bank & 0xFE) << 1);
        } else {
            this.setPrgBanks(4, 2, this.bank << 1);
            this.setPrgBanks(6, 2, -2);
        }
    }

    @Override
    public int readMemory(int address) {
        if (address >= 20480 && address < 21504) {
            return this.resetBit;
        }
        if (address >= 21504 && address < 24576) {
            return this.exRegs[address & 3];
        }
        return super.readMemory(address);
    }

    @Override
    public void writeMemory(int address, int value) {
        this.memory[address] = value;
        if (address >= 21504 && address < 24576) {
            this.exRegs[address & 3] = value;
        } else if (address >= 32768) {
            switch (address & 0x8C17) {
                case 32768: {
                    this.bank = value;
                    this.updateBanks();
                    break;
                }
                case 33792: {
                    this.mode = value;
                    this.updateBanks();
                    break;
                }
                case 34816: {
                    this.irqCounter = this.irqCounter & 0xFF00 | value;
                    this.cpu.setMapperIrq(false);
                    break;
                }
                case 34817: {
                    this.irqEnabled = BitUtil.getBitBool(this.mode, 7);
                    this.irqCounter = value << 8 | this.irqCounter & 0xFF;
                    break;
                }
                case 35840: {
                    this.regs[0] = value;
                    this.updateBanks();
                    break;
                }
                case 35841: {
                    this.regs[1] = value;
                    this.updateBanks();
                    break;
                }
                case 35842: {
                    this.regs[2] = value;
                    this.updateBanks();
                    break;
                }
                case 35856: {
                    this.regs[3] = value;
                    this.updateBanks();
                    break;
                }
                case 35857: {
                    this.regs[4] = value;
                    this.updateBanks();
                    break;
                }
                case 35862: {
                    this.regs[5] = value;
                    this.updateBanks();
                    break;
                }
                case 35863: {
                    this.regs[6] = value;
                    this.updateBanks();
                }
            }
        }
    }
}

