/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.unl;

import nintaco.files.CartFile;
import nintaco.mappers.konami.VRC2And4;

public class UNLTH2131_1
extends VRC2And4 {
    protected int irqLowCounter;
    protected int irqHighCounter;

    public UNLTH2131_1(CartFile cartFile) {
        super(cartFile);
        this.prgHigh = 32;
        this.variant = 1;
        this.useHeuristics = false;
    }

    private void writeIrqAcknowledgeAndReset() {
        this.cpu.setMapperIrq(false);
        this.irqEnabled = false;
        this.irqLowCounter = 0;
    }

    private void writeIrqCounterEnable() {
        this.irqEnabled = true;
    }

    private void writeIrqHighCounterValue(int value) {
        this.irqHighCounter = value >> 4;
    }

    @Override
    protected void writeRegister(int address, int value) {
        switch (address & 0xF003) {
            case 61440: {
                this.writeIrqAcknowledgeAndReset();
                break;
            }
            case 61441: {
                this.writeIrqCounterEnable();
                break;
            }
            case 61442: {
                break;
            }
            case 61443: {
                this.writeIrqHighCounterValue(value);
                break;
            }
            default: {
                super.writeRegister(address, value);
            }
        }
    }

    @Override
    public void update() {
        if (this.irqEnabled) {
            ++this.irqLowCounter;
            this.irqLowCounter &= 0xFFF;
            if (this.irqLowCounter == 2048) {
                --this.irqHighCounter;
                this.irqHighCounter &= 0xFF;
            }
            if (this.irqHighCounter == 0 && this.irqLowCounter < 2048) {
                this.cpu.setMapperIrq(true);
            }
        }
    }
}

