/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.unl;

import java.util.Arrays;
import nintaco.files.CartFile;
import nintaco.input.DeviceMapper;
import nintaco.input.familybasic.transformer.TransformerMapper;
import nintaco.mappers.Mapper;

public class Transformer
extends Mapper {
    private static final long serialVersionUID = 0L;
    private final int[] queue = new int[256];
    private boolean[] pressed0 = new boolean[256];
    private boolean[] pressed1 = new boolean[256];
    private int head;
    private int tail;
    private int cpuCycleCounter;
    private TransformerMapper transformerMapper;

    public Transformer(CartFile cartFile) {
        super(cartFile, 4, 1);
    }

    @Override
    public void init() {
        this.setPrgBank(2, 0);
        this.setPrgBank(3, -1);
        this.setChrBank(0);
    }

    @Override
    public void setDeviceMappers(DeviceMapper[] deviceMappers) {
        super.setDeviceMappers(deviceMappers);
        this.transformerMapper = null;
        for (int i = deviceMappers.length - 1; i >= 0; --i) {
            if (deviceMappers[i].getInputDevice() != 33) continue;
            this.transformerMapper = (TransformerMapper)deviceMappers[i];
            break;
        }
    }

    @Override
    public int readMemory(int address) {
        if (address >= 20480 && address <= 20484) {
            int value = this.head != this.tail ? this.queue[this.tail] : 0;
            switch (address & 3) {
                case 0: {
                    value &= 0xF;
                    break;
                }
                case 1: {
                    value >>= 4;
                    break;
                }
                case 2: {
                    if (this.head == this.tail) break;
                    this.tail = this.tail + 1 & 0xFF;
                }
            }
            this.cpu.setMapperIrq(false);
            return value;
        }
        return super.readMemory(address);
    }

    private void enqueue(int value) {
        this.queue[this.head] = value;
        this.head = this.head + 1 & 0xFF;
    }

    @Override
    public void update() {
        if (++this.cpuCycleCounter == 1000) {
            this.cpuCycleCounter = 0;
            TransformerMapper mapper = this.transformerMapper;
            if (mapper != null) {
                int i;
                Arrays.fill(this.pressed1, false);
                int scanCodes = mapper.getScanCodes();
                for (i = 2; i >= 0 && scanCodes != 0; scanCodes >>>= 8, --i) {
                    this.pressed1[scanCodes & 0xFF] = true;
                }
                for (i = 255; i >= 0; --i) {
                    if (this.pressed1[i] && !this.pressed0[i]) {
                        this.enqueue(i);
                        continue;
                    }
                    if (this.pressed1[i] || !this.pressed0[i]) continue;
                    this.enqueue(0x80 ^ i);
                }
                boolean[] temp = this.pressed0;
                this.pressed0 = this.pressed1;
                this.pressed1 = temp;
                if (this.head != this.tail) {
                    this.cpu.setMapperIrq(true);
                }
            }
        }
    }
}

