/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.unl;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class SMB2J
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int irqCounter;
    private boolean irqEnabled;

    public SMB2J(CartFile cartFile) {
        super(cartFile, 8, 1, 32768, 24576);
    }

    @Override
    public void init() {
        this.irqCounter = 0;
        this.irqEnabled = false;
        this.writeBankSelect(0);
        this.set4PrgBanks(4, 0);
    }

    @Override
    public void resetting() {
        this.init();
    }

    @Override
    public void update() {
        if (this.irqEnabled) {
            if (this.irqCounter < 5750) {
                ++this.irqCounter;
            } else {
                this.irqEnabled = false;
                this.cpu.setMapperIrq(true);
            }
        }
    }

    private void writeBankSelect(int value) {
        this.setPrgBank(3, 4 | value & 1);
    }

    private void writeIrqControl(int value) {
        this.irqEnabled = BitUtil.getBitBool(value, 0);
        this.irqCounter = 0;
        this.cpu.setMapperIrq(false);
    }

    @Override
    public int readMemory(int address) {
        return address >= 16450 && address <= 16469 ? 255 : super.readMemory(address);
    }

    @Override
    public void writeMemory(int address, int value) {
        super.writeMemory(address, value);
        switch (address) {
            case 16423: {
                this.writeBankSelect(value);
                break;
            }
            case 16488: {
                this.writeIrqControl(value);
            }
        }
    }
}

