/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.unl;

import nintaco.files.CartFile;
import nintaco.mappers.unif.unl.OneBus;

public class Mapper256
extends OneBus {
    private static final long serialVersionUID = 0L;
    private static final int[][] PPUMangle = new int[][]{{0, 1, 2, 3, 4, 5}, {1, 0, 5, 4, 3, 2}, {0, 1, 2, 3, 4, 5}, {5, 4, 3, 2, 0, 1}, {2, 5, 0, 4, 3, 1}, {0, 1, 2, 3, 4, 5}, {0, 1, 2, 3, 4, 5}, {0, 1, 2, 3, 4, 5}, {0, 1, 2, 3, 4, 5}, {0, 1, 2, 3, 4, 5}, {0, 1, 2, 3, 4, 5}, {0, 1, 2, 3, 4, 5}, {0, 1, 2, 3, 4, 5}, {0, 1, 2, 3, 4, 5}, {0, 1, 2, 3, 4, 5}, {0, 1, 2, 3, 4, 5}};
    private static final int[][] CPUMangle = new int[][]{{0, 1, 2, 3}, {0, 1, 2, 3}, {1, 0, 2, 3}, {0, 1, 2, 3}, {0, 1, 2, 3}, {0, 1, 2, 3}, {0, 1, 2, 3}, {0, 1, 2, 3}, {0, 1, 2, 3}, {0, 1, 2, 3}, {0, 1, 2, 3}, {0, 1, 2, 3}, {0, 1, 2, 3}, {0, 1, 2, 3}, {0, 1, 2, 3}, {0, 1, 2, 3}};
    private static final int[][] MMC3Mangle = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7}, {5, 4, 3, 2, 1, 0, 6, 7}, {0, 1, 2, 3, 4, 5, 7, 6}, {0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 2, 3, 4, 5, 6, 7}};
    private final int submapper;

    public Mapper256(CartFile cartFile) {
        super(cartFile);
        this.submapper = cartFile.getSubmapperNumber();
    }

    @Override
    protected void write2(int address, int value) {
        if (address >= 8210 && address <= 8215) {
            address = 8210 + PPUMangle[this.submapper][address - 8210];
        }
        super.write2(address, value);
    }

    @Override
    protected void write4(int address, int value) {
        if (address >= 16647 && address <= 16650) {
            address = 16647 + CPUMangle[this.submapper][address - 16647];
        }
        super.write4(address, value);
    }

    @Override
    protected void writeMMC3(int address, int value) {
        if ((address & 0xE001) == 32768) {
            value = value & 0xF8 | MMC3Mangle[this.submapper][value & 7];
        }
        super.writeMMC3(address, value);
    }
}

