/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.unl;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class FS304
extends Mapper {
    private static final long serialVersionUID = 0L;
    private final int[] regs = new int[]{3, 0, 0, 7};

    public FS304(CartFile cartFile) {
        super(cartFile, 2, 0);
    }

    @Override
    public void init() {
        this.updateBanks();
    }

    @Override
    public void writeMemory(int address, int value) {
        if ((address & 0xF000) == 20480) {
            this.regs[address >> 8 & 3] = value;
            this.updateBanks();
        } else {
            super.writeMemory(address, value);
        }
    }

    private void updateBanks() {
        int prgBank;
        switch (this.regs[3] & 7) {
            case 0: 
            case 2: {
                prgBank = this.regs[0] & 0xC | this.regs[1] & 2 | (this.regs[2] & 0xF) << 4;
                break;
            }
            case 1: 
            case 3: {
                prgBank = this.regs[0] & 0xC | (this.regs[2] & 0xF) << 4;
                break;
            }
            case 4: 
            case 6: {
                prgBank = this.regs[0] & 0xE | this.regs[1] >> 1 & 1 | (this.regs[2] & 0xF) << 4;
                break;
            }
            default: {
                prgBank = this.regs[0] & 0xF | (this.regs[2] & 0xF) << 4;
            }
        }
        this.setPrgBank(1, prgBank);
    }
}

