/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.unl;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC1;
import nintaco.util.BitUtil;

public class FARID_SLROM_8IN1
extends MMC1 {
    private static final long serialVersionUID = 0L;
    private boolean bankWritesEnabled;
    private int prgOuter;
    private int chrOuter;

    public FARID_SLROM_8IN1(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void init() {
        this.bankWritesEnabled = true;
        this.chrOuter = 0;
        this.prgOuter = 0;
        super.init();
    }

    @Override
    public void resetting() {
        this.init();
    }

    @Override
    public void writeMemory(int address, int value) {
        if ((address & 0xE000) == 24576) {
            if (this.prgRamEnabled) {
                if (this.bankWritesEnabled) {
                    this.bankWritesEnabled = !BitUtil.getBitBool(value, 3);
                    this.prgOuter = (value & 0x70) >> 1;
                    this.chrOuter = this.prgOuter << 2;
                    this.updateBanks();
                }
                super.writeMemory(address, value);
            }
        } else {
            super.writeMemory(address, value);
        }
    }

    @Override
    protected void setChrBank(int bank, int value) {
        super.setChrBank(bank, this.chrOuter | value & 0x1F);
    }

    @Override
    protected void setPrgBank(int bank, int value) {
        super.setPrgBank(bank, this.prgOuter | value & 7);
    }
}

