/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.unl;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class CityFighter
extends Mapper {
    private static final long serialVersionUID = 0L;
    private final int[] chrRegs = new int[8];
    private int prgReg;
    private int mirroring;
    private int irqCounter;
    private boolean irqEnabled;
    private boolean prgMode;

    public CityFighter(CartFile cartFile) {
        super(cartFile, 8, 8);
    }

    @Override
    public void init() {
        this.prgReg = 0;
        this.updateBanks();
    }

    private void updateBanks() {
        this.setPrgBanks(4, 4, this.prgReg & 0xFC);
        if (!this.prgMode) {
            this.setPrgBank(6, this.prgReg);
        }
        for (int i = 7; i >= 0; --i) {
            this.setChrBank(i, this.chrRegs[i]);
        }
        this.setNametableMirroring(this.mirroring);
    }

    @Override
    protected void writeRegister(int address, int value) {
        switch (address & 0xF00C) {
            case 36864: {
                this.prgReg = value & 0xC;
                this.mirroring = value & 3;
                break;
            }
            case 36868: 
            case 36872: 
            case 36876: {
                if (BitUtil.getBitBool(address, 11)) {
                    this.apu.dmc.writeDirectLoad((value & 0xF) << 3);
                    break;
                }
                this.prgReg = value & 0xC;
                break;
            }
            case 49152: 
            case 49156: 
            case 49160: 
            case 49164: {
                this.prgMode = BitUtil.toBitBool(value);
                break;
            }
            case 53248: {
                this.chrRegs[0] = this.chrRegs[0] & 0xF0 | value & 0xF;
                break;
            }
            case 53252: {
                this.chrRegs[0] = this.chrRegs[0] & 0xF | value << 4;
                break;
            }
            case 53256: {
                this.chrRegs[1] = this.chrRegs[1] & 0xF0 | value & 0xF;
                break;
            }
            case 53260: {
                this.chrRegs[1] = this.chrRegs[1] & 0xF | value << 4;
                break;
            }
            case 40960: {
                this.chrRegs[2] = this.chrRegs[2] & 0xF0 | value & 0xF;
                break;
            }
            case 40964: {
                this.chrRegs[2] = this.chrRegs[2] & 0xF | value << 4;
                break;
            }
            case 40968: {
                this.chrRegs[3] = this.chrRegs[3] & 0xF0 | value & 0xF;
                break;
            }
            case 40972: {
                this.chrRegs[3] = this.chrRegs[3] & 0xF | value << 4;
                break;
            }
            case 45056: {
                this.chrRegs[4] = this.chrRegs[4] & 0xF0 | value & 0xF;
                break;
            }
            case 45060: {
                this.chrRegs[4] = this.chrRegs[4] & 0xF | value << 4;
                break;
            }
            case 45064: {
                this.chrRegs[5] = this.chrRegs[5] & 0xF0 | value & 0xF;
                break;
            }
            case 45068: {
                this.chrRegs[5] = this.chrRegs[5] & 0xF | value << 4;
                break;
            }
            case 57344: {
                this.chrRegs[6] = this.chrRegs[6] & 0xF0 | value & 0xF;
                break;
            }
            case 57348: {
                this.chrRegs[6] = this.chrRegs[6] & 0xF | value << 4;
                break;
            }
            case 57352: {
                this.chrRegs[7] = this.chrRegs[7] & 0xF0 | value & 0xF;
                break;
            }
            case 57356: {
                this.chrRegs[7] = this.chrRegs[7] & 0xF | value << 4;
                break;
            }
            case 61440: {
                this.irqCounter = this.irqCounter & 0x1E0 | (value & 0xF) << 1;
                break;
            }
            case 61444: {
                this.irqCounter = this.irqCounter & 0x1E | (value & 0xF) << 5;
                break;
            }
            case 61448: {
                this.irqEnabled = BitUtil.getBitBool(value, 1);
                this.cpu.setMapperIrq(false);
            }
        }
        this.updateBanks();
    }

    @Override
    public void update() {
        if (this.irqEnabled && --this.irqCounter <= 0) {
            this.cpu.setMapperIrq(true);
        }
    }
}

