/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.bmc;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class WS
extends Mapper {
    private int reg0;
    private int reg1;

    public WS(CartFile cartFile) {
        super(cartFile, 8, 1, 24576, 32768);
    }

    @Override
    public void init() {
        this.reg1 = 0;
        this.reg0 = 0;
        this.updateBanks();
    }

    @Override
    public void resetting() {
        this.init();
    }

    private void updateBanks() {
        this.setChrBank(this.reg1 & 7);
        if (BitUtil.getBitBool(this.reg0, 3)) {
            int bank = (this.reg0 & 7) << 1;
            this.setPrgBanks(4, 2, bank);
            this.setPrgBanks(6, 2, bank);
        } else {
            this.setPrgBanks(4, 4, (this.reg0 & 6) << 1);
        }
        this.setNametableMirroring(BitUtil.getBit(this.reg0, 4));
    }

    @Override
    protected void writeRegister(int address, int value) {
        if (!BitUtil.getBitBool(this.reg0, 5)) {
            if (BitUtil.getBitBool(address, 0)) {
                this.reg1 = value;
            } else {
                this.reg0 = value;
            }
            this.updateBanks();
        }
    }
}

