/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.bmc;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class T262
extends Mapper {
    private static final long serialVersionUID = 0L;
    private boolean lock;
    private boolean mode;
    private int base;

    public T262(CartFile cartFile) {
        super(cartFile, 4, 0);
    }

    @Override
    public void resetting() {
        this.lock = false;
        this.mode = false;
        this.base = 0;
        this.init();
    }

    @Override
    protected void writeRegister(int address, int value) {
        if (!this.lock) {
            this.lock = BitUtil.getBitBool(address, 13);
            this.base = (address & 0x60) >> 2 | (address & 0x100) >> 3;
            this.mode = BitUtil.getBitBool(address, 7);
            this.setNametableMirroring(BitUtil.getBit(address, 1));
        }
        int bank = value & 7;
        this.setPrgBank(2, this.base | bank);
        this.setPrgBank(3, this.base | (this.mode ? bank : 7));
    }
}

