/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.bmc;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class Super24In1SC03
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private static final int[] PRG_BLOCK_MASKS = new int[]{63, 31, 15, 1, 3, 0, 0, 0};
    private boolean chrRamMode;
    private int bankSize = 36;
    private int prgBank = 159;
    private int chrBank;

    public Super24In1SC03(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void init() {
        this.updateBlocks();
    }

    @Override
    public int readVRAM(int address) {
        if (address < 8192 && !this.chrRamMode && this.chrAddressMask != 0) {
            return this.chrROM[(this.chrBanks[address >> this.chrShift] | address & this.chrAddressMask) & this.chrRomSizeMask];
        }
        return this.vram[address];
    }

    @Override
    public void writeMemory(int address, int value) {
        super.writeMemory(address, value);
        switch (address) {
            case 24560: {
                this.bankSize = value;
                this.updateBlocks();
                break;
            }
            case 24561: {
                this.prgBank = value;
                this.updateBlocks();
                break;
            }
            case 24562: {
                this.chrBank = value;
                this.updateBlocks();
            }
        }
    }

    private void updateBlocks() {
        int chrMask;
        int chrOffset;
        if (BitUtil.getBitBool(this.bankSize, 5)) {
            this.chrRamMode = true;
            chrOffset = 0;
            chrMask = 7;
        } else {
            this.chrRamMode = false;
            chrOffset = this.chrBank << 3;
            chrMask = 255;
        }
        this.setBlock(this.prgBank << 1, PRG_BLOCK_MASKS[this.bankSize & 7], chrOffset, chrMask);
    }
}

