/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.bmc;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class N625092
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int cmd;
    private int bank;
    private int ass;

    public N625092(CartFile cartFile) {
        super(cartFile, 4, 1);
    }

    @Override
    public void init() {
        this.cmd = 0;
        this.bank = 0;
        this.updateBanks();
    }

    @Override
    public void resetting() {
        this.init();
        ++this.ass;
    }

    private void updateBanks() {
        this.setNametableMirroring(this.cmd & 1);
        this.setChrBank(0);
        int high = (this.cmd & 0xFC) >> 2;
        if (BitUtil.getBitBool(this.cmd, 1)) {
            if (BitUtil.getBitBool(this.cmd, 8)) {
                this.setPrgBank(2, high | this.bank);
                this.setPrgBank(3, high | 7);
            } else {
                this.setPrgBank(2, high | this.bank & 6);
                this.setPrgBank(3, high | (this.bank & 6 | 1));
            }
        } else {
            this.setPrgBank(2, high | this.bank);
            this.setPrgBank(3, high | this.bank);
        }
    }

    @Override
    protected void writeRegister(int address, int value) {
        if (address >= 49152) {
            this.bank = address & 7;
            this.updateBanks();
        } else {
            this.cmd = address;
            if (address == 33016) {
                this.setPrgBank(2, this.ass);
                this.setPrgBank(3, this.ass);
            } else {
                this.updateBanks();
            }
        }
    }
}

