/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.bmc;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class FK23C
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private final int[] regs = new int[8];
    private final boolean[] chrRamBank = new boolean[8];
    private final int prgBonus;
    private final int prgMask;
    private final boolean FK23CA;
    private int unromCHR;
    private int dipswitch;
    private boolean bankSelectBit3;

    public FK23C(CartFile cartFile, boolean FK23CA) {
        super(cartFile);
        this.FK23CA = FK23CA;
        this.prgBonus = 0;
        this.prgMask = 127 >> this.prgBonus;
    }

    @Override
    public void init() {
        this.unromCHR = 0;
        this.bankSelectBit3 = false;
        this.regs[3] = 0;
        this.regs[2] = 0;
        this.regs[1] = 0;
        this.regs[0] = 0;
        this.regs[7] = 255;
        this.regs[6] = 255;
        this.regs[5] = 255;
        this.regs[4] = 255;
        this.writeMirroring(0);
        super.init();
    }

    @Override
    public void resetting() {
        this.dipswitch = this.dipswitch + 1 & 7;
        this.init();
    }

    @Override
    public void writeVRAM(int address, int value) {
        if (address < 8192 && this.chrRamBank[address >> this.chrShift] && this.chrAddressMask != 0) {
            this.vram[(this.chrBanks[address >> this.chrShift] | address & this.chrAddressMask) & 0x1FFF] = value;
        } else {
            this.vram[address] = value;
        }
    }

    @Override
    public int readVRAM(int address) {
        if (address < 8192 && this.chrAddressMask != 0) {
            if (this.chrRamBank[address >> this.chrShift]) {
                return this.vram[(this.chrBanks[address >> this.chrShift] | address & this.chrAddressMask) & 0x1FFF];
            }
            return this.chrROM[(this.chrBanks[address >> this.chrShift] | address & this.chrAddressMask) & this.chrRomSizeMask];
        }
        return this.vram[address];
    }

    @Override
    public void setChrBank(int bank, int value) {
        if (BitUtil.getBitBool(this.regs[0], 6)) {
            int B = (this.regs[2] | this.unromCHR) << 3;
            for (int i = 7; i >= 0; --i) {
                this.chrRamBank[i] = false;
                super.setChrBank(i, B | i);
            }
        } else if (BitUtil.getBitBool(this.regs[0], 5)) {
            this.chrRamBank[bank] = true;
            super.setChrBank(bank, value);
        } else {
            int B = (this.regs[2] & 0x7F) << 3;
            if (BitUtil.getBitBool(this.regs[3], 1)) {
                super.setChrBank(bank, B | value);
                this.chrRamBank[bank] = false;
                if (this.chrMode) {
                    super.setChrBank(4, B | this.R[0]);
                    super.setChrBank(5, B | this.regs[6]);
                    super.setChrBank(6, B | this.R[1]);
                    super.setChrBank(7, B | this.regs[7]);
                    this.chrRamBank[4] = false;
                    this.chrRamBank[5] = false;
                    this.chrRamBank[6] = false;
                    this.chrRamBank[7] = false;
                } else {
                    super.setChrBank(0, B | this.R[0]);
                    super.setChrBank(1, B | this.regs[6]);
                    super.setChrBank(2, B | this.R[1]);
                    super.setChrBank(3, B | this.regs[7]);
                    this.chrRamBank[0] = false;
                    this.chrRamBank[1] = false;
                    this.chrRamBank[2] = false;
                    this.chrRamBank[3] = false;
                }
            } else {
                super.setChrBank(bank, B | value);
                this.chrRamBank[bank] = false;
            }
        }
    }

    @Override
    public void setPrgBank(int bank, int value) {
        switch (this.regs[0] & 7) {
            case 3: {
                int B = this.regs[1] << 1;
                super.setPrgBank(4, B);
                super.setPrgBank(5, B | 1);
                super.setPrgBank(6, B);
                super.setPrgBank(7, B | 1);
                break;
            }
            case 4: {
                int B = (this.regs[1] & 0xFE) << 1;
                super.setPrgBank(4, B);
                super.setPrgBank(5, B | 1);
                super.setPrgBank(6, B | 2);
                super.setPrgBank(7, B | 3);
                break;
            }
            default: {
                if ((this.regs[0] & 3) != 0) {
                    int blocksize = 6 - (this.regs[0] & 3);
                    int mask = (1 << blocksize) - 1;
                    super.setPrgBank(bank, value & mask | this.regs[1] << 1);
                } else {
                    super.setPrgBank(bank, value & this.prgMask);
                }
                if (!BitUtil.getBitBool(this.regs[3], 1)) break;
                super.setPrgBank(6, this.regs[4]);
                super.setPrgBank(7, this.regs[5]);
            }
        }
    }

    @Override
    protected void writePrgRamProtect(int value) {
        super.writePrgRamProtect(value);
        super.setPrgBank(3, value & 3);
    }

    @Override
    protected void writeBankSelect(int value) {
        this.bankSelectBit3 = BitUtil.getBitBool(value, 3);
        super.writeBankSelect(value);
    }

    @Override
    public void writeRegister(int address, int value) {
        if (BitUtil.getBitBool(this.regs[0], 6)) {
            if ((this.regs[0] & 0x30) != 0) {
                this.unromCHR = 0;
            } else {
                this.unromCHR = value & 3;
                this.updateChrBanks();
            }
        } else if (address == 32769 && BitUtil.getBitBool(this.regs[3], 1) && this.bankSelectBit3) {
            this.regs[4 | this.register & 3] = value;
            this.updateBanks();
        } else {
            if (address < 49152 && this.FK23CA) {
                if (address == 32768 && value == 70) {
                    value = 71;
                } else if (address == 32768 && value == 71) {
                    value = 70;
                }
            }
            super.writeRegister(address, value);
        }
    }

    @Override
    public int readMemory(int address) {
        if (address >= 24576) {
            return this.prgROM[(this.prgBanks[address >> this.prgShift] | address & this.prgAddressMask) & this.prgRomSizeMask];
        }
        return this.memory[address];
    }

    @Override
    public void writeMemory(int address, int value) {
        if ((address & 0xF000) == 20480) {
            if (BitUtil.getBitBool(address, this.dipswitch + 4)) {
                this.regs[address & 3] = value;
                if ((this.regs[0] & 0xF0) == 32 || (address & 3) == 1 || (address & 3) == 2) {
                    this.updateBanks();
                }
            }
            if (this.FK23CA && BitUtil.getBitBool(this.regs[3], 1)) {
                this.regs[0] = this.regs[0] & 0xFFFFFFF8;
            }
        }
        super.writeMemory(address, value);
    }
}

