/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.bmc;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;

public class BMC830134C
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private int outerBank;
    private boolean gnromMode;

    public BMC830134C(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void init() {
        this.writeOuterBank(0);
    }

    @Override
    public void resetting() {
        this.init();
    }

    @Override
    protected void updatePrgBanks() {
        if (this.gnromMode) {
            this.setPrgBank(4, this.outerBank & 0xFD | this.R[6] & 0xF);
            this.setPrgBank(5, this.outerBank & 0xFD | this.R[7] & 0xF);
            this.setPrgBank(6, this.outerBank | this.R[6] & 0xF | 2);
            this.setPrgBank(7, this.outerBank | this.R[7] & 0xF | 2);
        } else {
            super.updatePrgBanks();
        }
    }

    private void writeOuterBank(int value) {
        this.outerBank = value & 6;
        this.gnromMode = this.outerBank == 6;
        this.outerBank <<= 3;
        if (this.gnromMode) {
            this.setPrgBlock(0, -1);
        } else {
            this.setPrgBlock(this.outerBank, 15);
        }
        this.setChrBlock((value & 1) << 8 | (value & 2) << 6 | (value & 8) << 3, 255);
    }

    @Override
    public void writeMemory(int address, int value) {
        if ((address & 0xE000) == 24576) {
            this.writeOuterBank(value);
        }
        super.writeMemory(address, value);
    }
}

