/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.bmc;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class BMC8157
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int command;
    private int resetData;

    public BMC8157(CartFile cartFile) {
        super(cartFile, 4, 0);
    }

    @Override
    public void init() {
        this.resetData = 65533;
        this.updateBanks();
    }

    @Override
    public void resetting() {
        this.command = 0;
        this.resetData ^= 2;
        this.updateBanks();
    }

    @Override
    public int readMemory(int address) {
        if (address >= 32768 && BitUtil.getBitBool(this.command, 8) && this.prgRomLength < 0x100000) {
            address &= this.resetData;
        }
        return super.readMemory(address);
    }

    @Override
    protected void writeRegister(int address, int value) {
        this.command = address;
        this.updateBanks();
    }

    private void updateBanks() {
        int base = (this.command & 0x60 | (this.command & 0x100) >> 1) >> 2;
        int bank = (this.command & 0x1C) >> 2;
        int lBank = BitUtil.getBitBool(this.command, 9) ? 7 : (BitUtil.getBitBool(this.command, 7) ? bank : 0);
        this.setPrgBank(2, base | bank);
        this.setPrgBank(3, base | lBank);
        this.setNametableMirroring(BitUtil.getBit(this.command, 1));
    }
}

